"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cell = require("./cell");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderRow = ({
  columns,
  leftAction,
  spacingForRowIdentifier = false
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "reorderableTableHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, leftAction && /*#__PURE__*/_react.default.createElement(_cell.Cell, _constants.DRAGGABLE_UX_STYLE, leftAction), spacingForRowIdentifier && /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({}, _constants.DRAGGABLE_UX_STYLE, {
    flexBasis: "24px"
  })), columns.map((column, columnIndex) => /*#__PURE__*/_react.default.createElement(_cell.Cell, (0, _extends2.default)({
    key: `table_header_cell_${columnIndex}`
  }, column), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, column.name))))))));
};
exports.HeaderRow = HeaderRow;