"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchPageTemplateWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _flash_messages = require("../flash_messages");
var _http = require("../http");
var _kibana = require("../kibana");
var _loading = require("../loading");
require("./page_template.scss");
var _endpoints_header_action = require("./endpoints_header_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * EnterpriseSearchPageTemplateWrapper is a light wrapper for KibanaPageTemplate (which
 * is a light wrapper for EuiPageTemplate). It should contain only concerns shared
 * between both AS & WS, which should have their own AppSearchPageTemplate &
 * WorkplaceSearchPageTemplate sitting on top of this template (:nesting_dolls:),
 * which in turn manages individual product-specific concerns (e.g. side navs, telemetry, etc.)
 *
 * @see https://github.com/elastic/kibana/tree/main/src/plugins/kibana_react/public/page_template
 * @see https://elastic.github.io/eui/#/layout/page
 */

const EnterpriseSearchPageTemplateWrapper = ({
  children,
  className,
  customPageSections,
  hideFlashMessages,
  isLoading,
  isEmptyState,
  emptyState,
  setPageChrome,
  solutionNav,
  solutionNavIcon,
  useEndpointHeaderActions = true,
  ...pageTemplateProps
}) => {
  var _pageTemplateProps$ma;
  const {
    readOnlyMode
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    renderHeaderActions
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const hasCustomEmptyState = !!emptyState;
  const showCustomEmptyState = hasCustomEmptyState && isEmptyState;
  const navIcon = solutionNavIcon !== null && solutionNavIcon !== void 0 ? solutionNavIcon : 'logoEnterpriseSearch';
  (0, _react.useLayoutEffect)(() => {
    if (useEndpointHeaderActions) {
      renderHeaderActions(_endpoints_header_action.EndpointsHeaderAction);
    }
    return () => {
      renderHeaderActions(undefined);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, (0, _extends2.default)({
    restrictWidth: false
  }, pageTemplateProps, {
    className: (0, _classnames.default)('enterpriseSearchPageTemplate', className),
    mainProps: {
      ...pageTemplateProps.mainProps,
      className: (0, _classnames.default)('enterpriseSearchPageTemplate__content', (_pageTemplateProps$ma = pageTemplateProps.mainProps) === null || _pageTemplateProps$ma === void 0 ? void 0 : _pageTemplateProps$ma.className)
    },
    isEmptyState: isEmptyState && !isLoading,
    solutionNav: solutionNav && solutionNav.items ? {
      icon: navIcon,
      ...solutionNav
    } : undefined
  }), setPageChrome, readOnlyMode && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "lock",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.readOnlyMode.warning', {
      defaultMessage: 'Enterprise Search is in read-only mode. You will be unable to make changes such as creating, editing, or deleting.'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), !hideFlashMessages && /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null), isLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : showCustomEmptyState ? emptyState : customPageSections ? children : /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, null, children));
};
exports.EnterpriseSearchPageTemplateWrapper = EnterpriseSearchPageTemplateWrapper;