"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _source_icons = require("../../workplace_search/components/shared/assets/source_icons");
require("./icon_row.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const icons = [{
  icon: 'logoElasticsearch',
  title: 'Elasticsearch',
  tooltip: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.elasticsearch.tooltip', {
    defaultMessage: 'Use App and Workplace Search Search Engines with existing Elasticsearch indices'
  })
}, {
  icon: 'desktop',
  title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.api.title', {
    defaultMessage: 'API'
  }),
  tooltip: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.api.tooltip', {
    defaultMessage: 'POST documents to an API endpoint from your own applications'
  })
}, {
  icon: 'globe',
  title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.crawler.title', {
    defaultMessage: 'Elastic Web Crawler'
  }),
  tooltip: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.crawler.tooltip', {
    defaultMessage: 'Automatically index content from your websites'
  })
}, {
  icon: _source_icons.images.confluence,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.confluence.title', {
    defaultMessage: 'Confluence'
  }),
  tooltip: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.confluence.tooltip', {
    defaultMessage: 'Index content from Atlassian Confluence'
  })
}, {
  icon: _source_icons.images.googleDrive,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.googleDrive.title', {
    defaultMessage: 'Google Drive'
  }),
  tooltip: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.googleDrive.tooltip', {
    defaultMessage: 'Index documents from Google Drive'
  })
}, {
  icon: _source_icons.images.sharePoint,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.sharePoint.title', {
    defaultMessage: 'Microsoft SharePoint'
  }),
  tooltip: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.sharePoint.tooltip', {
    defaultMessage: 'Index content from Microsoft SharePoint'
  })
}, {
  icon: _source_icons.images.github,
  title: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.github.title', {
    defaultMessage: 'GitHub'
  }),
  tooltip: _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.github.tooltip', {
    defaultMessage: 'Index issues, pull requests, and more from GitHub'
  })
}];
const IconRow = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    className: "gettingStartedSteps"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, icons.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", {
        className: "iconTooltip"
      }, item.title), item.tooltip)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "grayscaleSvg",
      type: item.icon,
      size: "m",
      color: "text"
    })));
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.overview.iconRow.manyMoreBadge', {
    defaultMessage: 'And many more'
  }))));
};
exports.IconRow = IconRow;