"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderHeaderActions = exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRedux = require("react-redux");
var _kea = require("kea");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _enterprise_search_url = require("./shared/enterprise_search_url");
var _flash_messages = require("./shared/flash_messages");
var _get_cloud_enterprise_search_host = require("./shared/get_cloud_enterprise_search_host/get_cloud_enterprise_search_host");
var _http = require("./shared/http");
var _kibana = require("./shared/kibana");
var _licensing = require("./shared/licensing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This file serves as a reusable wrapper to share Kibana-level context and other helpers
 * between various Enterprise Search plugins (e.g. AppSearch, WorkplaceSearch, ES landing page)
 * which should be imported and passed in as the first param in plugin.ts.
 */

const renderApp = (App, {
  params,
  core,
  plugins,
  isSidebarEnabled = true
}, {
  config,
  data,
  esConfig
}) => {
  var _core$application$cap, _core$application$cap2;
  const {
    access,
    appSearch,
    configuredLimits,
    enterpriseSearchVersion,
    errorConnectingMessage,
    features,
    kibanaVersion,
    publicUrl,
    readOnlyMode,
    searchOAuth,
    workplaceSearch
  } = data;
  const {
    history
  } = params;
  const {
    application,
    chrome,
    http,
    uiSettings
  } = core;
  const {
    capabilities,
    navigateToUrl
  } = application;
  const {
    charts,
    cloud,
    guidedOnboarding,
    lens,
    security,
    share,
    ml
  } = plugins;
  const entCloudHost = (0, _get_cloud_enterprise_search_host.getCloudEnterpriseSearchHost)(plugins.cloud);
  _enterprise_search_url.externalUrl.enterpriseSearchUrl = publicUrl || entCloudHost || config.host || '';
  const noProductAccess = {
    hasAppSearchAccess: false,
    hasWorkplaceSearchAccess: false
  };
  const productAccess = access || noProductAccess;
  const productFeatures = features !== null && features !== void 0 ? features : {
    ..._constants.DEFAULT_PRODUCT_FEATURES
  };
  const EmptyContext = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  const CloudContext = (cloud === null || cloud === void 0 ? void 0 : cloud.CloudContextProvider) || EmptyContext;
  (0, _kea.resetContext)({
    createStore: true
  });
  const store = (0, _kea.getContext)().store;
  let user = null;
  try {
    security.authc.getCurrentUser().then(newUser => {
      user = newUser;
    }).catch(() => {
      user = null;
    });
  } catch {
    user = null;
  }
  const unmountKibanaLogic = (0, _kibana.mountKibanaLogic)({
    application,
    capabilities,
    charts,
    cloud,
    config,
    esConfig,
    data: plugins.data,
    guidedOnboarding,
    history,
    isSidebarEnabled,
    lens,
    ml,
    navigateToUrl,
    productAccess,
    productFeatures,
    renderHeaderActions: HeaderActions => params.setHeaderActionMenu(HeaderActions ? renderHeaderActions.bind(null, HeaderActions, store, params) : undefined),
    security,
    setBreadcrumbs: chrome.setBreadcrumbs,
    setChromeIsVisible: chrome.setIsVisible,
    setDocTitle: chrome.docTitle.change,
    share,
    uiSettings,
    user
  });
  const unmountLicensingLogic = (0, _licensing.mountLicensingLogic)({
    canManageLicense: (_core$application$cap = core.application.capabilities.management) === null || _core$application$cap === void 0 ? void 0 : (_core$application$cap2 = _core$application$cap.stack) === null || _core$application$cap2 === void 0 ? void 0 : _core$application$cap2.license_management,
    license$: plugins.licensing.license$
  });
  const unmountHttpLogic = (0, _http.mountHttpLogic)({
    errorConnectingMessage,
    http,
    readOnlyMode
  });
  const unmountFlashMessagesLogic = (0, _flash_messages.mountFlashMessagesLogic)();
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$: params.theme$
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins
    }
  }, /*#__PURE__*/_react.default.createElement(CloudContext, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: params.history
  }, /*#__PURE__*/_react.default.createElement(App, {
    access: productAccess,
    appSearch: appSearch,
    configuredLimits: configuredLimits,
    enterpriseSearchVersion: enterpriseSearchVersion,
    features: features,
    kibanaVersion: kibanaVersion,
    readOnlyMode: readOnlyMode,
    searchOAuth: searchOAuth,
    workplaceSearch: workplaceSearch
  }), /*#__PURE__*/_react.default.createElement(_flash_messages.Toasts, null))))))), params.element);
  return () => {
    _reactDom.default.unmountComponentAtNode(params.element);
    unmountKibanaLogic();
    unmountLicensingLogic();
    unmountHttpLogic();
    unmountFlashMessagesLogic();
    plugins.data.search.session.clear();
  };
};

/**
 * Render function for Kibana's header action menu chrome -
 * reusable by any Enterprise Search plugin simply by passing in
 * a custom HeaderActions component (e.g., WorkplaceSearchHeaderActions)
 * @see https://github.com/elastic/kibana/blob/main/docs/development/core/public/kibana-plugin-core-public.appmountparameters.setheaderactionmenu.md
 */
exports.renderApp = renderApp;
const renderHeaderActions = (HeaderActions, store, params, kibanaHeaderEl) => {
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$: params.theme$
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(HeaderActions, null)))), kibanaHeaderEl);
  return () => _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), kibanaHeaderEl);
};
exports.renderHeaderActions = renderHeaderActions;