"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorStatusToColor = connectorStatusToColor;
exports.connectorStatusToText = connectorStatusToText;
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function connectorStatusToText(connectorStatus) {
  if (connectorStatus === _searchConnectors.ConnectorStatus.CREATED || connectorStatus === _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.connectorStatus.needsConfig.label', {
      defaultMessage: 'Needs Configuration'
    });
  }
  if (connectorStatus === _searchConnectors.ConnectorStatus.ERROR) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.connectorStatus.connectorFailure.label', {
      defaultMessage: 'Connector Failure'
    });
  }
  if (connectorStatus === _searchConnectors.ConnectorStatus.CONFIGURED) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.configured.label', {
      defaultMessage: 'Configured'
    });
  }
  if (connectorStatus === _searchConnectors.ConnectorStatus.CONNECTED) {
    return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.connected.label', {
      defaultMessage: 'Connected'
    });
  }
  return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionStatus.incomplete.label', {
    defaultMessage: 'Incomplete'
  });
}
function connectorStatusToColor(connectorStatus) {
  if (connectorStatus === _searchConnectors.ConnectorStatus.CONNECTED) {
    return 'success';
  }
  if (connectorStatus === _searchConnectors.ConnectorStatus.ERROR) {
    return 'danger';
  }
  return 'warning';
}