"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsLogic = void 0;
var _kea = require("kea");
var _util = require("react-use/lib/util");
var _constants = require("../../../../../common/constants");
var _api = require("../../../../../common/types/api");
var _kibana = require("../../../shared/kibana");
var _get_default_pipeline_api_logic = require("../../api/connector/get_default_pipeline_api_logic");
var _update_default_pipeline_api_logic = require("../../api/connector/update_default_pipeline_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SettingsLogic = (0, _kea.kea)({
  actions: {
    setPipeline: pipeline => ({
      pipeline
    })
  },
  connect: {
    actions: [_update_default_pipeline_api_logic.UpdateDefaultPipelineApiLogic, ['apiSuccess', 'apiError', 'makeRequest'], _get_default_pipeline_api_logic.FetchDefaultPipelineApiLogic, ['apiError as fetchDefaultPipelineError', 'apiSuccess as fetchDefaultPipelineSuccess', 'makeRequest as fetchDefaultPipeline']],
    values: [_get_default_pipeline_api_logic.FetchDefaultPipelineApiLogic, ['data as defaultPipeline', 'status as fetchStatus'], _update_default_pipeline_api_logic.UpdateDefaultPipelineApiLogic, ['status']]
  },
  events: ({
    actions
  }) => ({
    afterMount: () => {
      if (_kibana.KibanaLogic.values.productFeatures.hasDefaultIngestPipeline === false) return;
      actions.fetchDefaultPipeline(undefined);
    }
  }),
  listeners: ({
    actions
  }) => ({
    apiSuccess: pipeline => {
      actions.fetchDefaultPipelineSuccess(pipeline);
    },
    fetchDefaultPipelineSuccess: pipeline => {
      actions.setPipeline(pipeline);
    }
  }),
  path: ['enterprise_search', 'content', 'settings'],
  reducers: () => ({
    pipelineState: [_constants.DEFAULT_PIPELINE_VALUES, {
      setPipeline: (_, {
        pipeline
      }) => pipeline
    }],
    showModal: [false, {
      apiSuccess: () => false,
      closeModal: () => false,
      openModal: () => true
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    hasNoChanges: [() => [selectors.pipelineState, selectors.defaultPipeline], (pipelineState, defaultPipeline) => (0, _util.isDeepEqual)(pipelineState, defaultPipeline)],
    isLoading: [() => [selectors.status, selectors.fetchStatus], (status, fetchStatus) => [_api.Status.LOADING, _api.Status.IDLE].includes(fetchStatus) || status === _api.Status.LOADING]
  })
});
exports.SettingsLogic = SettingsLogic;