"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartModelButton = exports.SelectedModel = exports.NoModelSelected = exports.ModelStartingButton = exports.ModelSelect = exports.ModelDeployingButton = exports.DeployModelButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ml = require("../../../../../../../common/types/ml");
var _license_badge = require("./license_badge");
var _model_select_logic = require("./model_select_logic");
var _model_select_option = require("./model_select_option");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeployModelButton = ({
  onClick,
  modelId,
  disabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClick,
    disabled: disabled,
    color: "primary",
    iconType: "download",
    size: "s",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.deployButton.ariaLabel', {
      defaultMessage: 'Deploy {modelId} model',
      values: {
        modelId
      }
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.deployButton.label', {
    defaultMessage: 'Deploy'
  }));
};
exports.DeployModelButton = DeployModelButton;
const ModelDeployingButton = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: true,
    color: "primary",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.deployingButton.label', {
    defaultMessage: 'Deploying'
  }))));
};
exports.ModelDeployingButton = ModelDeployingButton;
const StartModelButton = ({
  onClick,
  modelId,
  disabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClick,
    disabled: disabled,
    color: "success",
    iconType: "play",
    size: "s",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.startButton.ariaLabel', {
      defaultMessage: 'Start {modelId} model',
      values: {
        modelId
      }
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.startButton.label', {
    defaultMessage: 'Start'
  }));
};
exports.StartModelButton = StartModelButton;
const ModelStartingButton = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: true,
    color: "success",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.startingButton.label', {
    defaultMessage: 'Starting'
  }))));
};
exports.ModelStartingButton = ModelStartingButton;
const NoModelSelected = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  color: "subdued",
  style: {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center'
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  textAlign: "center",
  color: "subdued",
  size: "s"
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.noModelSelectedPanel.text', {
  defaultMessage: 'Select an available model to add to your inference pipeline'
})));
exports.NoModelSelected = NoModelSelected;
const SelectedModel = model => {
  const {
    createModel,
    startModel
  } = (0, _kea.useActions)(_model_select_logic.ModelSelectLogic);
  const {
    areActionButtonsDisabled
  } = (0, _kea.useValues)(_model_select_logic.ModelSelectLogic);
  const getSelectedModelAnnouncement = selectedModel => selectedModel.isPlaceholder ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.selectedModelNotDeployedAnnouncement', {
    defaultMessage: '{modelId} model selected but not deployed',
    values: {
      modelId: selectedModel.modelId
    }
  }) : selectedModel.deploymentState === _ml.MlModelDeploymentState.NotDeployed ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.selectedModelNotStartedAnnouncement', {
    defaultMessage: '{modelId} model selected but not started',
    values: {
      modelId: selectedModel.modelId
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.selectedModelAnnouncement', {
    defaultMessage: '{modelId} model selected',
    values: {
      modelId: selectedModel.modelId
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    title: "Selected model"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderLive, null, getSelectedModelAnnouncement(model)), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, model.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, model.modelId)), model.description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, model.description)), model.licenseType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_license_badge.LicenseBadge, {
    licenseType: model.licenseType,
    modelDetailsPageUrl: model.modelDetailsPageUrl
  }))), (model.isPlaceholder || [_ml.MlModelDeploymentState.Downloading, _ml.MlModelDeploymentState.NotDeployed, _ml.MlModelDeploymentState.Starting].includes(model.deploymentState)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "aria-live": "polite",
    "aria-atomic": "false"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, model.isPlaceholder ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(DeployModelButton, {
    onClick: () => createModel(model.modelId),
    modelId: model.modelId,
    disabled: areActionButtonsDisabled
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.modelNotDeployedError', {
    defaultMessage: 'Model must be deployed before use.'
  })))))) : model.deploymentState === _ml.MlModelDeploymentState.Downloading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ModelDeployingButton, null)) : model.deploymentState === _ml.MlModelDeploymentState.NotDeployed ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StartModelButton, {
    onClick: () => startModel(model.modelId),
    modelId: model.modelId,
    disabled: areActionButtonsDisabled
  })) : model.deploymentState === _ml.MlModelDeploymentState.Starting ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ModelStartingButton, null)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)))))));
};
exports.SelectedModel = SelectedModel;
const ModelSelect = () => {
  const {
    addInferencePipelineModal: {
      configuration,
      indexName
    },
    ingestionMethod,
    isLoading,
    selectableModels,
    selectedModel
  } = (0, _kea.useValues)(_model_select_logic.ModelSelectLogic);
  const {
    setInferencePipelineConfiguration
  } = (0, _kea.useActions)(_model_select_logic.ModelSelectLogic);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    modelID,
    pipelineName,
    isPipelineNameUserSupplied
  } = configuration;
  const rowHeight = (0, _eui.useIsWithinMaxBreakpoint)('s') ? euiTheme.base * 8 : euiTheme.base * 6;
  const maxVisibleOptions = 4.5;
  const [listHeight, setListHeight] = (0, _react.useState)(maxVisibleOptions * rowHeight);
  const getModelSelectOptionProps = models => (models !== null && models !== void 0 ? models : []).map(model => ({
    label: model.modelId,
    checked: model.modelId === modelID ? 'on' : undefined,
    data: {
      ...model
    }
  }));
  const onChange = options => {
    var _selectedModelOption$, _selectedModelOption$2, _selectedModelOption$3;
    const selectedModelOption = options.find(option => option.checked === 'on');
    setInferencePipelineConfiguration({
      ...configuration,
      inferenceConfig: undefined,
      modelID: (_selectedModelOption$ = selectedModelOption === null || selectedModelOption === void 0 ? void 0 : selectedModelOption.data.modelId) !== null && _selectedModelOption$ !== void 0 ? _selectedModelOption$ : '',
      isModelPlaceholderSelected: (_selectedModelOption$2 = selectedModelOption === null || selectedModelOption === void 0 ? void 0 : selectedModelOption.data.isPlaceholder) !== null && _selectedModelOption$2 !== void 0 ? _selectedModelOption$2 : false,
      fieldMappings: undefined,
      pipelineName: isPipelineNameUserSupplied ? pipelineName : indexName + '-' + (0, _utils.normalizeModelName)((_selectedModelOption$3 = selectedModelOption === null || selectedModelOption === void 0 ? void 0 : selectedModelOption.data.modelId) !== null && _selectedModelOption$3 !== void 0 ? _selectedModelOption$3 : '')
    });
  };
  const onSearchChange = (_, matchingOptions) => {
    setListHeight(Math.min(maxVisibleOptions, matchingOptions.length) * rowHeight);
  };
  const renderOption = option => {
    const {
      data,
      ...optionExclData
    } = option;
    const flattenedOption = {
      ...optionExclData,
      ...data
    };
    return /*#__PURE__*/_react.default.createElement(_model_select_option.ModelSelectOption, flattenedOption);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-selectTrainedModel`,
    options: getModelSelectOptionProps(selectableModels),
    singleSelection: "always",
    listProps: {
      bordered: true,
      rowHeight,
      onFocusBadge: false
    },
    height: listHeight,
    onChange: onChange,
    renderOption: renderOption,
    isLoading: isLoading,
    searchable: true,
    searchProps: {
      onChange: onSearchChange
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, selectedModel ? /*#__PURE__*/_react.default.createElement(SelectedModel, selectedModel) : /*#__PURE__*/_react.default.createElement(NoModelSelected, null)));
};
exports.ModelSelect = ModelSelect;