"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelStarted = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../../shared/kibana");
var _utils = require("../utils");
var _e5_multilingual_callout = require("./e5_multilingual_callout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ModelStarted = ({
  dismiss,
  isCompact,
  isDismissable,
  isSingleThreaded
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "primary"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "checkInCircleFilled",
  color: "primary"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "primary",
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h3", null, isSingleThreaded ? isCompact ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.startedSingleThreadedTitleCompact', {
  defaultMessage: 'Your E5 model is running single-threaded.'
}) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.startedSingleThreadedTitle', {
  defaultMessage: 'Your E5 model has started single-threaded.'
}) : isCompact ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.startedTitleCompact', {
  defaultMessage: 'Your E5 model is running.'
}) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.startedTitle', {
  defaultMessage: 'Your E5 model has started.'
})))), isDismissable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_e5_multilingual_callout.E5MultilingualDismissButton, {
  dismiss: dismiss
})))), !isCompact && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, isSingleThreaded ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.startedSingleThreadedBody', {
  defaultMessage: 'This single-threaded configuration is great for testing your custom inference pipelines, however performance should be fine-tuned for production.'
}) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.startedBody', {
  defaultMessage: 'Enjoy the power of E5 in your custom Inference pipeline.'
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  gutterSize: "m",
  alignItems: "center",
  justifyContent: "flexStart"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, isSingleThreaded ? /*#__PURE__*/_react.default.createElement(_e5_multilingual_callout.FineTuneModelsButton, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconSide: "left",
  iconType: "wrench",
  onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_utils.TRAINED_MODELS_PATH, {
    shouldNotCreateHref: true
  })
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.e5MultilingualCallOut.viewModelsButton', {
  defaultMessage: 'View details'
}))))))));
exports.ModelStarted = ModelStarted;