"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeployModel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _e5_multilingual_callout = require("./e5_multilingual_callout");
var _e5_multilingual_callout_logic = require("./e5_multilingual_callout_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeployModel = ({
  dismiss,
  ingestionMethod,
  isCreateButtonDisabled,
  isDismissable
}) => {
  const {
    createE5MultilingualModel
  } = (0, _kea.useActions)(_e5_multilingual_callout_logic.E5MultilingualCalloutLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.titleBadge",
    defaultMessage: "New"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "primary",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.title', {
    defaultMessage: 'Improve your results with E5'
  })))), isDismissable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_e5_multilingual_callout.E5MultilingualDismissButton, {
    dismiss: dismiss
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedHTMLMessage, {
    id: "xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.body",
    defaultMessage: "E5 (EmbEddings from bidirEctional Encoder rEpresentations) is an NLP model that enables you to perform multi-lingual semantic search by using dense vector representations. This model performs best for non-English language documents and queries.",
    tagName: "p"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-e5MultilingualCallOut-deployModel`,
    disabled: isCreateButtonDisabled,
    iconType: "launch",
    onClick: () => createE5MultilingualModel()
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.e5MultilingualCallOut.deployButton.label', {
    defaultMessage: 'Deploy'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://www.elastic.co/search-labs/blog/articles/multilingual-vector-search-e5-embedding-model"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.index.pipelines.e5MultilingualCallOut.learnMoreLink",
    defaultMessage: "Learn more"
  })))))))));
};
exports.DeployModel = DeployModel;