"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceHistoryLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../common/types/api");
var _fetch_ml_inference_pipeline_history = require("../../../api/pipelines/fetch_ml_inference_pipeline_history");
var _index_name_logic = require("../index_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceHistoryLogic = (0, _kea.kea)({
  connect: {
    actions: [_fetch_ml_inference_pipeline_history.FetchMlInferencePipelineHistoryApiLogic, ['makeRequest as fetchIndexInferenceHistory', 'apiError as fetchIndexInferenceHistoryError']],
    values: [_index_name_logic.IndexNameLogic, ['indexName'], _fetch_ml_inference_pipeline_history.FetchMlInferencePipelineHistoryApiLogic, ['data as inferenceHistoryData', 'status as fetchIndexInferenceHistoryStatus']]
  },
  path: ['enterprise_search', 'content', 'pipelines_inference_history'],
  selectors: ({
    selectors
  }) => ({
    inferenceHistory: [() => [selectors.inferenceHistoryData], inferenceHistoryData => inferenceHistoryData === null || inferenceHistoryData === void 0 ? void 0 : inferenceHistoryData.history],
    isLoading: [() => [selectors.fetchIndexInferenceHistoryStatus], fetchIndexInferenceHistoryStatus => fetchIndexInferenceHistoryStatus !== _api.Status.SUCCESS && fetchIndexInferenceHistoryStatus !== _api.Status.ERROR]
  })
});
exports.InferenceHistoryLogic = InferenceHistoryLogic;