"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexIndexMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _strip_search_prefix = require("../../../../../common/utils/strip_search_prefix");
var _doc_links = require("../../../shared/doc_links");
var _kibana = require("../../../shared/kibana");
var _mappings_logic = require("../../api/mappings/mappings_logic");
var _access_control_index_selector = require("./components/access_control_index_selector/access_control_index_selector");
var _index_name_logic = require("./index_name_logic");
var _index_view_logic = require("./index_view_logic");
require("./index_mappings.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexIndexMappings = () => {
  var _error$body;
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    hasDocumentLevelSecurityFeature
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const [selectedIndexType, setSelectedIndexType] = (0, _react.useState)('content-index');
  const indexToShow = selectedIndexType === 'content-index' ? indexName : (0, _strip_search_prefix.stripSearchPrefix)(indexName, _constants.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX);
  const {
    makeRequest: makeMappingRequest
  } = (0, _kea.useActions)((0, _mappings_logic.mappingsWithPropsApiLogic)(indexToShow));
  const {
    data: mappingData,
    error
  } = (0, _kea.useValues)((0, _mappings_logic.mappingsWithPropsApiLogic)(indexToShow));
  const shouldShowAccessControlSwitch = hasDocumentLevelSecurityFeature && productFeatures.hasDocumentLevelSecurityEnabled;
  const isAccessControlIndexNotFound = shouldShowAccessControlSwitch && (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404;
  (0, _react.useEffect)(() => {
    makeMappingRequest({
      indexName: indexToShow
    });
  }, [indexToShow, indexName]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, shouldShowAccessControlSwitch && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "enterpriseSearchMappingsSelector"
  }, /*#__PURE__*/_react.default.createElement(_access_control_index_selector.AccessControlIndexSelector, {
    onChange: setSelectedIndexType,
    valueOfSelected: selectedIndexType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, isAccessControlIndexNotFound ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.mappings.noIndex.title', {
      defaultMessage: 'Access Control Index not found'
    }),
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.mappings.noIndex', {
    defaultMessage: "An Access Control Index won't be created until you enable document-level security and run your first access control sync."
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true
  }, JSON.stringify(mappingData, null, 2))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "iInCircle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.mappings.title', {
    defaultMessage: 'About index mappings'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchIndex.mappings.description",
    defaultMessage: "Your documents are made up of a set of fields. Index mappings give each field a type (such as {keyword}, {number}, or {date}) and additional subfields. These index mappings determine the functions available in your relevance tuning and search experience.",
    values: {
      keyword: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "keyword"),
      number: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "number"),
      date: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "date")
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.elasticsearchMapping,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.mappings.docLink', {
    defaultMessage: 'Learn more'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "iInCircle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.transform.title', {
    defaultMessage: 'Transform your searchable content'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchIndex.transform.description",
    defaultMessage: "Want to add custom fields, or use trained ML models to analyze and enrich your indexed documents? Use index-specific ingest pipelines to customize documents to your needs."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.ingestPipelines,
    target: "_blank",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.transform.docLink', {
    defaultMessage: 'Learn more'
  }))))));
};
exports.SearchIndexIndexMappings = SearchIndexIndexMappings;