"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteDomainModalLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../../common/types/api");
var _delete_crawler_domain_api_logic = require("../../../../api/crawler/delete_crawler_domain_api_logic");
var _index_name_logic = require("../../index_name_logic");
var _crawler_logic = require("../crawler_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteDomainModalLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'delete_domain_modal'],
  connect: {
    actions: [_delete_crawler_domain_api_logic.DeleteCrawlerDomainApiLogic, ['apiError', 'apiSuccess']],
    values: [_delete_crawler_domain_api_logic.DeleteCrawlerDomainApiLogic, ['status']]
  },
  actions: {
    deleteDomain: () => true,
    hideModal: () => true,
    showModal: domain => ({
      domain
    })
  },
  reducers: {
    domain: [null, {
      showModal: (_, {
        domain
      }) => domain
    }],
    isHidden: [true, {
      apiError: () => true,
      apiSuccess: () => true,
      hideModal: () => true,
      showModal: () => false
    }]
  },
  listeners: ({
    values
  }) => ({
    apiSuccess: () => {
      _crawler_logic.CrawlerLogic.actions.fetchCrawlerData();
    },
    deleteDomain: () => {
      const {
        domain
      } = values;
      const {
        indexName
      } = _index_name_logic.IndexNameLogic.values;
      if (domain) {
        _delete_crawler_domain_api_logic.DeleteCrawlerDomainApiLogic.actions.makeRequest({
          domain,
          indexName
        });
      }
    }
  }),
  selectors: ({
    selectors
  }) => ({
    isLoading: [() => [selectors.status], status => status === _api.Status.LOADING]
  })
});
exports.DeleteDomainModalLogic = DeleteDomainModalLogic;