"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlRequestsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _custom_formatted_timestamp = require("../../../../../shared/custom_formatted_timestamp/custom_formatted_timestamp");
var _crawl_detail_logic = require("../crawl_details_flyout/crawl_detail_logic");
var _crawler_logic = require("../crawler_logic");
var _constants = require("./constants");
var _crawl_event_type_badge = require("./crawl_event_type_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlRequestsTable = () => {
  const {
    events
  } = (0, _kea.useValues)(_crawler_logic.CrawlerLogic);
  const {
    fetchCrawlRequest
  } = (0, _kea.useActions)(_crawl_detail_logic.CrawlDetailLogic);
  const columns = [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsTable.column.domainURL', {
      defaultMessage: 'Request ID'
    }),
    render: (id, event) => {
      if (event.stage === 'crawl') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => {
            fetchCrawlRequest(id);
          }
        }, id);
      }
      return /*#__PURE__*/_react.default.createElement("span", null, id);
    }
  }, {
    field: 'createdAt',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsTable.column.created', {
      defaultMessage: 'Created'
    }),
    render: createdAt => /*#__PURE__*/_react.default.createElement(_custom_formatted_timestamp.CustomFormattedTimestamp, {
      timestamp: createdAt
    })
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsTable.column.crawlType', {
      defaultMessage: 'Crawl type'
    }),
    render: (_, event) => /*#__PURE__*/_react.default.createElement(_crawl_event_type_badge.CrawlEventTypeBadge, {
      event: event
    })
  }, {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsTable.column.domains', {
      defaultMessage: 'Domains'
    }),
    render: event => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, event.crawlConfig.domainAllowlist.length)
  }, {
    field: 'status',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsTable.column.status', {
      defaultMessage: 'Status'
    }),
    render: status => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: _constants.crawlStatusColors[status]
    }, _constants.readableCrawlerStatuses[status])
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: events,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "tableDensityExpanded",
      title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsTable.emptyPrompt.title', {
        defaultMessage: 'No recent crawl requests'
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsTable.emptyPrompt.body', {
        defaultMessage: "You haven't started any crawls yet."
      }))
    })
  });
};
exports.CrawlRequestsTable = CrawlRequestsTable;