"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlRequestsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _data_panel = require("../../../../../shared/data_panel/data_panel");
var _crawler_logic = require("../crawler_logic");
var _crawl_requests_table = require("./crawl_requests_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CRAWLER_LOGS_DISCOVER_RECORD = {
  columns: ['@timestamp', 'crawler.crawl.id', 'url.domain', 'url.path', 'event.action', 'http.response.status_code'],
  dataViewSpec: {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsPanel.discoverCrawlerLogsTitle', {
      defaultMessage: 'All Crawler Logs'
    }),
    timeFieldName: '@timestamp',
    title: 'logs-elastic_crawler-default'
  },
  sort: [['@timestamp', 'desc']]
};
const CrawlRequestsPanel = () => {
  const {
    data
  } = (0, _kea.useValues)(_crawler_logic.CrawlerLogic);
  const {
    services: {
      discover
    }
  } = (0, _public.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsPanel.title', {
      defaultMessage: 'Crawl requests'
    })),
    titleSize: "s",
    iconType: "documents",
    action: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        var _discover$locator;
        return (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate(CRAWLER_LOGS_DISCOVER_RECORD);
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsPanel.linkToDiscover', {
      defaultMessage: 'View in Discover'
    })),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsPanel.description', {
      defaultMessage: "Recent crawl requests are logged here. You can track progress and examine crawl events in Kibana's Discover or Logs user intefaces"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlRequestsPanel.userAgentDescription', {
    defaultMessage: 'Requests originating from the crawler can be identified by the following User Agent. This is configured in your enterprise-search.yml file.'
  }), ' '), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, data ? data.userAgent : '')), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_requests_table.CrawlRequestsTable, null));
};
exports.CrawlRequestsPanel = CrawlRequestsPanel;