"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlCustomSettingsFlyoutMultipleCrawlTabs = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _crawl_custom_settings_flyout_multi_crawl_logic = require("./crawl_custom_settings_flyout_multi_crawl_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CRAWLER_TAB_PREFIX = _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.multipleCrawlTabPrefix', {
  defaultMessage: 'Crawl'
});
const CrawlCustomSettingsFlyoutMultipleCrawlTabs = () => {
  const {
    crawlerConfigActiveTab,
    crawlerConfigurations
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_multi_crawl_logic.CrawlCustomSettingsFlyoutMultiCrawlLogic);
  const {
    onAddCustomCrawler,
    onSelectCrawlerConfigActiveTab
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_multi_crawl_logic.CrawlCustomSettingsFlyoutMultiCrawlLogic);
  const crawlerTabData = crawlerConfigurations.map((_, index) => ({
    key: `crawler_${index}`,
    index,
    label: `${CRAWLER_TAB_PREFIX} ${index + 1}`
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, crawlerTabData.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.key,
    isSelected: crawlerConfigActiveTab === tab.index,
    onClick: () => onSelectCrawlerConfigActiveTab(tab.index)
  }, tab.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => onAddCustomCrawler(crawlerConfigurations.length)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "plus"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.CrawlCustomSettingsFlyoutMultipleCrawlTabs = CrawlCustomSettingsFlyoutMultipleCrawlTabs;