"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorOverviewPanels = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _routes = require("../../../routes");
var _types = require("../../../types");
var _indices = require("../../../utils/indices");
var _ingestion_status_helpers = require("../../../utils/ingestion_status_helpers");
var _index_view_logic = require("../index_view_logic");
var _search_index = require("../search_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusPanel = ({
  ingestionStatus
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  color: (0, _ingestion_status_helpers.ingestionStatusToColor)(ingestionStatus),
  hasShadow: false,
  paddingSize: "l"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
  titleSize: "m",
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connector.ingestionStatus.title', {
    defaultMessage: 'Ingestion status'
  }),
  title: (0, _ingestion_status_helpers.ingestionStatusToText)(ingestionStatus)
}));
const ConnectorOverviewPanels = () => {
  const {
    ingestionStatus,
    index
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  return (0, _indices.isConnectorIndex)(index) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary",
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "entSearchContent-indexOverview-totalStats-documentCount",
    titleSize: "m",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.totalStats.documentCountCardLabel', {
      defaultMessage: 'Document count'
    }),
    title: index.count
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-test-subj": "entSearchContent-indexOverview-connectorStats-ingestionStatus"
  }, ingestionStatus === _types.IngestionStatus.INCOMPLETE ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
      indexName: index.name,
      tabId: _search_index.SearchIndexTabId.CONFIGURATION
    })
  }, /*#__PURE__*/_react.default.createElement(StatusPanel, {
    ingestionStatus: ingestionStatus
  })) : /*#__PURE__*/_react.default.createElement(StatusPanel, {
    ingestionStatus: ingestionStatus
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.ConnectorOverviewPanels = ConnectorOverviewPanels;