"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewIndexCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METHOD_CARD_OPTIONS = {
  [_constants.INGESTION_METHOD_IDS.CRAWLER]: {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.crawler.description', {
      defaultMessage: 'Discover, extract, and index searchable content from websites and knowledge bases'
    }),
    footer: {
      buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.crawler.label', {
        defaultMessage: 'Use a web crawler'
      }),
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.crawler.nocodeLabel', {
        defaultMessage: 'No code'
      })
    },
    icon: (0, _utils.getIngestionMethodIconType)(_constants.INGESTION_METHOD_IDS.CRAWLER),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.crawler.title', {
      defaultMessage: 'Web crawler'
    })
  },
  [_constants.INGESTION_METHOD_IDS.CONNECTOR]: {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.connector.description', {
      defaultMessage: 'Extract, transform, index and sync data from a data source via native or customized connectors'
    }),
    footer: {
      buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.connector.label', {
        defaultMessage: 'Use a connector'
      })
    },
    icon: (0, _utils.getIngestionMethodIconType)(_constants.INGESTION_METHOD_IDS.CONNECTOR),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.connector.title', {
      defaultMessage: 'Connector'
    })
  },
  [_constants.INGESTION_METHOD_IDS.API]: {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.api.description', {
      defaultMessage: 'Add documents programmatically by connecting with the API'
    }),
    footer: {
      buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.api.label', {
        defaultMessage: 'Use the API'
      })
    },
    icon: (0, _utils.getIngestionMethodIconType)(_constants.INGESTION_METHOD_IDS.API),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.methodCard.api.title', {
      defaultMessage: 'API'
    })
  }
};
const NewIndexCard = ({
  disabled,
  onSelect,
  isSelected,
  type
}) => {
  if (!METHOD_CARD_OPTIONS[type]) {
    return null;
  }
  const {
    icon,
    title,
    description,
    footer
  } = METHOD_CARD_OPTIONS[type];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    isDisabled: disabled,
    "data-test-subj": "entSearch-content-newIndexCard-cardBody",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: icon,
      size: "xxl"
    }),
    title: title,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, description),
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, footer.label && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, footer.label), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: disabled,
      "data-test-subj": `entSearchContent-newIndexCard-button-${type}`,
      fullWidth: true,
      onClick: onSelect,
      color: isSelected ? 'success' : 'primary',
      iconType: isSelected ? 'checkInCircleFilled' : undefined
    }, footer.buttonLabel))
  });
};
exports.NewIndexCard = NewIndexCard;