"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.baseBreadcrumbs = exports.Connectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _encode_path_params = require("../../../shared/encode_path_params");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _table_pagination = require("../../../shared/table_pagination");
var _routes = require("../../routes");
var _layout = require("../layout");
var _select_connector = require("../new_index/select_connector/select_connector");
var _cannot_connect = require("../search_index/components/cannot_connect");
var _connector_stats = require("./connector_stats");
var _connectors_logic = require("./connectors_logic");
var _connectors_table = require("./connectors_table");
var _crawler_empty_state = require("./crawler_empty_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseBreadcrumbs = [_i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.breadcrumb', {
  defaultMessage: 'Connectors'
})];
exports.baseBreadcrumbs = baseBreadcrumbs;
const Connectors = ({
  isCrawler
}) => {
  const {
    fetchConnectors,
    onPaginate,
    setIsFirstRequest
  } = (0, _kea.useActions)(_connectors_logic.ConnectorsLogic);
  const {
    data,
    isLoading,
    searchParams,
    isEmpty,
    connectors
  } = (0, _kea.useValues)(_connectors_logic.ConnectorsLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const [searchQuery, setSearchValue] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    setIsFirstRequest();
  }, [isCrawler]);
  (0, _react.useEffect)(() => {
    fetchConnectors({
      ...searchParams,
      searchQuery,
      fetchCrawlersOnly: isCrawler
    });
  }, [searchParams.from, searchParams.size, searchQuery, isCrawler]);
  return !isLoading && isEmpty && !isCrawler ? /*#__PURE__*/_react.default.createElement(_select_connector.SelectConnector, null) : /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchContentPageTemplate, {
    pageChrome: baseBreadcrumbs,
    pageViewTelemetry: !isCrawler ? 'Connectors' : 'Web Crawlers',
    isLoading: isLoading,
    pageHeader: {
      pageTitle: !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectors.title', {
        defaultMessage: 'Elasticsearch connectors'
      }) : _i18n.i18n.translate('xpack.enterpriseSearch.crawlers.title', {
        defaultMessage: 'Elasticsearch web crawlers'
      }),
      rightSideGroupProps: {
        gutterSize: 's'
      },
      rightSideItems: isLoading ? [] : !isCrawler ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "newConnector",
        color: "primary",
        iconType: "plusInCircle",
        fill: true,
        onClick: () => {
          _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_SELECT_CONNECTOR_PATH);
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.connectors.newConnectorButtonLabel",
        defaultMessage: "New Connector"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "newConnectorNative",
        onClick: () => {
          _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_SELECT_CONNECTOR_NATIVE_PATH);
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.newNativeConnectorButtonLabel', {
        defaultMessage: 'New Native Connector'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "newConnectorClient",
        onClick: () => {
          _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_SELECT_CONNECTOR_CLIENTS_PATH);
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.newConnectorsClientButtonLabel', {
        defaultMessage: 'New Connector Client'
      }))] : [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        disabled: Boolean(errorConnectingMessage),
        key: "newCrawler",
        color: "primary",
        iconType: "plusInCircle",
        fill: true,
        onClick: () => {
          _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.NEW_INDEX_METHOD_PATH, {
            type: _constants.INGESTION_METHOD_IDS.CRAWLER
          }));
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.connectors.newCrawlerButtonLabel', {
        defaultMessage: 'New web crawler'
      }))]
    }
  }, Boolean(errorConnectingMessage) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cannot_connect.CannotConnect, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_connector_stats.ConnectorStats, {
    isCrawler: isCrawler
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isEmpty && isCrawler ? /*#__PURE__*/_react.default.createElement(_crawler_empty_state.CrawlerEmptyState, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorsTable.h2.availableConnectorsLabel",
    defaultMessage: "Available connectors"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorsTable.h2.availableCrawlersLabel",
    defaultMessage: "Available web crawlers"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: searchQuery,
    box: {
      incremental: true,
      placeholder: !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterConnectorsPlaceholder', {
        defaultMessage: 'Filter connectors'
      }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterCrawlersPlaceholder', {
        defaultMessage: 'Filter web crawlers'
      })
    },
    "aria-label": !isCrawler ? _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterConnectorsLabel', {
      defaultMessage: 'Filter connectors'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.connectorsTable.euiSearchBar.filterCrawlersLabel', {
      defaultMessage: 'Filter web crawlers'
    }),
    onChange: event => setSearchValue(event.queryText)
  })), /*#__PURE__*/_react.default.createElement(_connectors_table.ConnectorsTable, {
    items: connectors || [],
    meta: data === null || data === void 0 ? void 0 : data.meta,
    onChange: (0, _table_pagination.handlePageChange)(onPaginate)
  }))));
};
exports.Connectors = Connectors;