"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndexPipelineParams = exports.FetchIndexPipelineParametersApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchIndexPipelineParams = async ({
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/pipeline_parameters`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchIndexPipelineParams = fetchIndexPipelineParams;
const FetchIndexPipelineParametersApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_index_pipeline_params_api_logic'], fetchIndexPipelineParams, {
  showErrorFlash: false
});
exports.FetchIndexPipelineParametersApiLogic = FetchIndexPipelineParametersApiLogic;