"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteMlInferencePipeline = exports.DeleteMlInferencePipelineApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteMlInferencePipeline = async args => {
  const route = `/internal/enterprise_search/indices/${args.indexName}/ml_inference/pipeline_processors/${args.pipelineName}`;
  return await _http.HttpLogic.values.http.delete(route);
};
exports.deleteMlInferencePipeline = deleteMlInferencePipeline;
const DeleteMlInferencePipelineApiLogic = (0, _create_api_logic.createApiLogic)(['delete_ml_inference_pipeline_api_logic'], deleteMlInferencePipeline);
exports.DeleteMlInferencePipelineApiLogic = DeleteMlInferencePipelineApiLogic;