"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchModels = exports.FetchModelsApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchModels = async () => {
  const route = '/internal/enterprise_search/ml/models';
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchModels = fetchModels;
const FetchModelsApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_models_api_logic'], fetchModels, {
  showErrorFlash: false
});
exports.FetchModelsApiLogic = FetchModelsApiLogic;