"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createE5MultilingualModel = exports.CreateE5MultilingualModelApiLogic = void 0;
var _create_api_logic = require("../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createE5MultilingualModel = async ({
  modelId
}) => {
  const route = `/internal/enterprise_search/ml/models/${modelId}`;
  return await _http.HttpLogic.values.http.post(route);
};
exports.createE5MultilingualModel = createE5MultilingualModel;
const CreateE5MultilingualModelApiLogic = (0, _create_api_logic.createApiLogic)(['create_e5_multilingual_model_api_logic'], createE5MultilingualModel, {
  showErrorFlash: false
});
exports.CreateE5MultilingualModelApiLogic = CreateE5MultilingualModelApiLogic;