"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteCrawlerDomain = exports.DeleteCrawlerDomainApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteCrawlerDomain = async ({
  domain,
  indexName
}) => {
  await _http.HttpLogic.values.http.delete(`/internal/enterprise_search/indices/${indexName}/crawler/domains/${domain.id}`);
  return {
    domain
  };
};
exports.deleteCrawlerDomain = deleteCrawlerDomain;
const DeleteCrawlerDomainApiLogic = (0, _create_api_logic.createApiLogic)(['delete_crawler_domain'], deleteCrawlerDomain, {
  showSuccessFlashFn: ({
    domain
  }) => _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainsTable.action.delete.successMessage', {
    defaultMessage: "Successfully deleted domain '{domainUrl}'",
    values: {
      domainUrl: domain.url
    }
  })
});
exports.DeleteCrawlerDomainApiLogic = DeleteCrawlerDomainApiLogic;