"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCrawlerIndex = exports.CreateCrawlerIndexApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCrawlerIndex = async ({
  indexName,
  language
}) => {
  const route = '/internal/enterprise_search/crawler';
  const params = {
    index_name: indexName,
    language
  };
  return await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify(params)
  });
};
exports.createCrawlerIndex = createCrawlerIndex;
const CreateCrawlerIndexApiLogic = (0, _create_api_logic.createApiLogic)(['create_crawler_index_api_logic'], createCrawlerIndex);
exports.CreateCrawlerIndexApiLogic = CreateCrawlerIndexApiLogic;