"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startSync = exports.StartSyncApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const startSync = async ({
  connectorId,
  nextSyncConfig
}) => {
  const route = `/internal/enterprise_search/connectors/${connectorId}/start_sync`;
  return await _http.HttpLogic.values.http.post(route, {
    // ConnectorConfiguration type is a record of key-value pair where value is a string
    // To store nextSyncConfig into ConnectorConfiguration the object should be casted to string
    body: JSON.stringify({
      nextSyncConfig: JSON.stringify(nextSyncConfig)
    })
  });
};
exports.startSync = startSync;
const StartSyncApiLogic = (0, _create_api_logic.createApiLogic)(['start_sync_api_logic'], startSync, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.index.syncSuccess.message', {
    defaultMessage: 'Successfully scheduled a sync, waiting for a connector to pick it up'
  })
});
exports.StartSyncApiLogic = StartSyncApiLogic;