"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSearchApplicationFieldCapabilities = exports.FetchSearchApplicationFieldCapabilitiesApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSearchApplicationFieldCapabilities = async ({
  name
}) => {
  const route = `/internal/enterprise_search/search_applications/${name}/field_capabilities`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchSearchApplicationFieldCapabilities = fetchSearchApplicationFieldCapabilities;
const FetchSearchApplicationFieldCapabilitiesApiLogic = (0, _create_api_logic.createApiLogic)(['search_applications', 'fetch_search_application_field_capabilities_api_logic'], fetchSearchApplicationFieldCapabilities);
exports.FetchSearchApplicationFieldCapabilitiesApiLogic = FetchSearchApplicationFieldCapabilitiesApiLogic;