"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceEnginesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _app_logic = require("../../../app_logic");
var _routes = require("../../../routes");
var _encode_path_params = require("../../../utils/encode_path_params");
var _shared_columns = require("../../engines/components/tables/shared_columns");
var _i18n = require("../i18n");
var _source_engines_logic = require("../source_engines_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceEnginesTable = () => {
  const {
    myRole: {
      canManageMetaEngineSourceEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    removeSourceEngine
  } = (0, _kea.useActions)(_source_engines_logic.SourceEnginesLogic);
  const {
    sourceEngines
  } = (0, _kea.useValues)(_source_engines_logic.SourceEnginesLogic);
  const columns = [{
    ..._shared_columns.NAME_COLUMN,
    render: engineName => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      to: (0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_PATH, {
        engineName
      })
    }, engineName)
  }, _shared_columns.DOCUMENT_COUNT_COLUMN, _shared_columns.FIELD_COUNT_COLUMN];
  if (canManageMetaEngineSourceEngines) {
    columns.push({
      name: _shared_columns.ACTIONS_COLUMN.name,
      actions: [{
        name: _i18n.REMOVE_SOURCE_ENGINE_BUTTON_LABEL,
        description: _i18n.REMOVE_SOURCE_ENGINE_BUTTON_LABEL,
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        onClick: engine => {
          if (confirm((0, _i18n.REMOVE_SOURCE_ENGINE_CONFIRM_DIALOGUE)(engine.name))) {
            removeSourceEngine(engine.name);
          }
        }
      }]
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: sourceEngines,
    columns: columns,
    pagination: sourceEngines.length > 10,
    search: {
      box: {
        incremental: true
      }
    }
  });
};
exports.SourceEnginesTable = SourceEnginesTable;