"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexJobLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../../shared/flash_messages");
var _http = require("../../../../shared/http");
var _engine = require("../../engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReindexJobLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'reindex_job_logic'],
  actions: {
    loadReindexJob: id => id,
    onLoadSuccess: response => response,
    onLoadError: true
  },
  reducers: {
    dataLoading: [true, {
      loadReindexJob: () => true,
      onLoadSuccess: () => false,
      onLoadError: () => false
    }],
    fieldCoercionErrors: [{}, {
      onLoadSuccess: (_, {
        fieldCoercionErrors
      }) => fieldCoercionErrors
    }]
  },
  listeners: ({
    actions
  }) => ({
    loadReindexJob: async id => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        engineName
      } = _engine.EngineLogic.values;
      try {
        const response = await http.get(`/internal/app_search/engines/${engineName}/reindex_job/${id}`);
        actions.onLoadSuccess(response);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
        actions.onLoadError();
      }
    }
  })
});
exports.ReindexJobLogic = ReindexJobLogic;