"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _role_mapping = require("../../../shared/role_mapping");
var _constants2 = require("../../../shared/role_mapping/constants");
var _routes = require("../../routes");
var _layout = require("../layout");
var _constants3 = require("./constants");
var _role_mapping2 = require("./role_mapping");
var _role_mappings_logic = require("./role_mappings_logic");
var _user = require("./user");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleMappings = () => {
  const {
    enableRoleBasedAccess,
    initializeRoleMappings,
    initializeRoleMapping,
    initializeSingleUserRoleMapping,
    handleDeleteMapping,
    resetState
  } = (0, _kea.useActions)(_role_mappings_logic.RoleMappingsLogic);
  const {
    roleMappings,
    singleUserRoleMappings,
    dataLoading,
    roleMappingFlyoutOpen,
    singleUserRoleMappingFlyoutOpen
  } = (0, _kea.useValues)(_role_mappings_logic.RoleMappingsLogic);
  (0, _react.useEffect)(() => {
    initializeRoleMappings();
    return resetState;
  }, []);
  const hasUsers = singleUserRoleMappings.length > 0;
  const rolesEmptyState = /*#__PURE__*/_react.default.createElement(_role_mapping.RolesEmptyPrompt, {
    productName: _constants.APP_SEARCH_PLUGIN.NAME,
    docsLink: _routes.SECURITY_DOCS_URL,
    onEnable: enableRoleBasedAccess
  });
  const roleMappingsSection = /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement(_role_mapping.RoleMappingsHeading, {
    productName: _constants.APP_SEARCH_PLUGIN.NAME,
    docsLink: _routes.SECURITY_DOCS_URL,
    onClick: () => initializeRoleMapping()
  }), /*#__PURE__*/_react.default.createElement(_role_mapping.RoleMappingsTable, {
    roleMappings: roleMappings,
    accessItemKey: "engines",
    accessHeader: _constants3.ROLE_MAPPINGS_ENGINE_ACCESS_HEADING,
    initializeRoleMapping: initializeRoleMapping,
    handleDeleteMapping: handleDeleteMapping
  }));
  const usersTable = /*#__PURE__*/_react.default.createElement(_role_mapping.UsersTable, {
    accessItemKey: "engines",
    singleUserRoleMappings: singleUserRoleMappings,
    initializeSingleUserRoleMapping: initializeSingleUserRoleMapping,
    handleDeleteMapping: handleDeleteMapping
  });
  const usersSection = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_role_mapping.UsersHeading, {
    onClick: () => initializeSingleUserRoleMapping()
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), hasUsers ? usersTable : /*#__PURE__*/_react.default.createElement(_role_mapping.UsersEmptyPrompt, null));
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: [_constants2.ROLE_MAPPINGS_TITLE],
    pageHeader: {
      pageTitle: _constants2.ROLE_MAPPINGS_TITLE
    },
    isLoading: dataLoading,
    isEmptyState: roleMappings.length < 1,
    emptyState: rolesEmptyState
  }, roleMappingFlyoutOpen && /*#__PURE__*/_react.default.createElement(_role_mapping2.RoleMapping, null), singleUserRoleMappingFlyoutOpen && /*#__PURE__*/_react.default.createElement(_user.User, null), roleMappingsSection, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), usersSection);
};
exports.RoleMappings = RoleMappings;