"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BoostItemContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _types = require("../../types");
var _functional_boost_form = require("./functional_boost_form");
var _proximity_boost_form = require("./proximity_boost_form");
var _value_boost_form = require("./value_boost_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BoostItemContent = ({
  boost,
  index,
  name
}) => {
  const {
    deleteBoost,
    updateBoostFactor
  } = (0, _kea.useActions)(_.RelevanceTuningLogic);
  const {
    type
  } = boost;
  const getBoostForm = () => {
    switch (type) {
      case _types.BoostType.Value:
        return /*#__PURE__*/_react.default.createElement(_value_boost_form.ValueBoostForm, {
          boost: boost,
          index: index,
          name: name
        });
      case _types.BoostType.Functional:
        return /*#__PURE__*/_react.default.createElement(_functional_boost_form.FunctionalBoostForm, {
          boost: boost,
          index: index,
          name: name
        });
      case _types.BoostType.Proximity:
        return /*#__PURE__*/_react.default.createElement(_proximity_boost_form.ProximityBoostForm, {
          boost: boost,
          index: index,
          name: name
        });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "none",
    className: "relevanceTuningAccordionItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), getBoostForm(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.impactLabel', {
      defaultMessage: 'Impact'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    min: 0,
    max: 10,
    step: 0.1,
    value: boost.factor,
    onChange: e => updateBoostFactor(name, index, parseFloat(e.target.value)),
    showInput: true,
    compressed: true,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    iconType: "cross",
    size: "s",
    onClick: () => deleteBoost(name, index)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.boosts.deleteBoostButtonLabel', {
    defaultMessage: 'Delete boost'
  })));
};
exports.BoostItemContent = BoostItemContent;