"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyEngineOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _routes = require("../../routes");
var _document_creation = require("../document_creation");
var _illustration = _interopRequireDefault(require("../document_creation/illustration.svg"));
var _engine = require("../engine");
var _layout = require("../layout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyEngineOverview = () => {
  const {
    isElasticsearchEngine,
    engine: {
      elasticsearchIndexName
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const elasticsearchEmptyState = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "ElasticsearchIndexEmptyState",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _illustration.default,
      alt: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.elasticsearchEngine.emptyStateIllustrationAltText', {
        defaultMessage: 'Illustration'
      })
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.elasticsearchEngine.emptyStateTitle', {
      defaultMessage: 'Add documents to your index'
    })),
    layout: "horizontal",
    hasBorder: true,
    color: "plain",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.elasticsearchEngine.helperText', {
      defaultMessage: "Your Elasticsearch index, {elasticsearchIndexName}, doesn't have any documents yet. Open Index Management in Kibana to make changes to your Elasticsearch indices.",
      values: {
        elasticsearchIndexName
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      fill: true,
      to: '/app/management/data/index_management/indices',
      shouldNotCreateHref: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.elasticsearchEngine.emptyStateButton', {
      defaultMessage: 'Manage indices'
    })))
  });
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)(),
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.overview.empty.heading', {
        defaultMessage: 'Engine setup'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        href: _routes.DOCS_URL,
        target: "_blank",
        iconType: "popout"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.overview.empty.headingAction', {
        defaultMessage: 'View documentation'
      }))]
    },
    "data-test-subj": "EngineOverview"
  }, isElasticsearchEngine ? elasticsearchEmptyState : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_document_creation.DocumentCreationButtons, null), /*#__PURE__*/_react.default.createElement(_document_creation.DocumentCreationFlyout, null)));
};
exports.EmptyEngineOverview = EmptyEngineOverview;