"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectEngineType = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _engine_creation_logic = require("./engine_creation_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectEngineType = () => {
  const {
    engineType
  } = (0, _kea.useValues)(_engine_creation_logic.EngineCreationLogic);
  const {
    setEngineType,
    setCreationStep
  } = (0, _kea.useActions)(_engine_creation_logic.EngineCreationLogic);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "entSearch__createEngineLayout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: [{
      onClick: () => {},
      status: 'current',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.searchEngineType.label', {
        defaultMessage: 'Search engine type'
      })
    }, {
      onClick: () => setCreationStep(_engine_creation_logic.EngineCreationSteps.ConfigureStep),
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.configuration.label', {
        defaultMessage: 'Configuration'
      })
    }, {
      onClick: () => {},
      status: 'disabled',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.review.label', {
        defaultMessage: 'Review'
      })
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.selectEngineTypeForm.title', {
    defaultMessage: 'Select a search engine type'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: "center"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.selectEngineTypeForm.description', {
    defaultMessage: `
                You can now create search engines that use an existing
                Elasticsearch index to combine the search management tools of App
                Search with the flexibility of Elasticsearch indices.
              `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://www.elastic.co/guide/en/app-search/current/elasticsearch-engines.html",
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.selectEngineTypeForm.description.link', {
    defaultMessage: 'Learn more'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.selectEngine.appSearch.title', {
      defaultMessage: 'App Search managed docs'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.selectEngine.appSearch.description', {
      defaultMessage: `
                    Use App Search APIs to manage your documents. App Search will write your documents into an underlying index and manage it for you.
                  `
    }),
    selectable: {
      isSelected: engineType === 'appSearch',
      onClick: () => setEngineType('appSearch')
    },
    "data-test-subj": "AppSearchEngineSelectable",
    hasBorder: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.selectEngine.elasticsearch.title', {
      defaultMessage: 'Elasticsearch index-based'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.selectEngine.elasticsearch.description', {
      defaultMessage: `
                    Use an existing index to manage your documents.
                    Adds search with App Search to Elasticsearch indices.
                    Some functions require specific subfields.
                  `
    }),
    selectable: {
      isSelected: engineType === 'elasticsearch',
      onClick: () => setEngineType('elasticsearch')
    },
    "data-test-subj": "ElasticsearchEngineSelectable",
    hasBorder: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "arrowRight",
    iconSide: "right",
    onClick: () => {
      setCreationStep(_engine_creation_logic.EngineCreationSteps.ConfigureStep);
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.nextStep.buttonLabel', {
    defaultMessage: 'Continue'
  }))))));
};
exports.SelectEngineType = SelectEngineType;