"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
var _constants = require("../constants");
var _creation_response_components = require("../creation_response_components");
var _2 = require(".");
require("./json_flyout.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JsonFlyout = () => {
  var _tabs$find;
  const {
    activeJsonTab
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  const {
    setActiveJsonTab
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  const tabs = [{
    id: 'uploadTab',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.jsonFlyout.uploadTabName', {
      defaultMessage: 'Upload'
    }),
    content: /*#__PURE__*/_react.default.createElement(_2.UploadJsonFileTabContent, null)
  }, {
    id: 'pasteTab',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.jsonFlyout.pasteTabName', {
      defaultMessage: 'Paste'
    }),
    content: /*#__PURE__*/_react.default.createElement(_2.PasteJsonTextTabContent, null)
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    className: "enterpriseSearchTabbedFlyoutHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: _constants.FLYOUT_ARIA_LABEL_ID
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.jsonFlyout.title', {
    defaultMessage: 'Paste or upload JSON'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false
  }, tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: index,
    onClick: () => setActiveJsonTab(tab.id),
    isSelected: tab.id === activeJsonTab
  }, tab.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: /*#__PURE__*/_react.default.createElement(_creation_response_components.Errors, null)
  }, (_tabs$find = tabs.find(tab => tab.id === activeJsonTab)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, activeJsonTab === 'uploadTab' ? /*#__PURE__*/_react.default.createElement(_2.UploadJsonFileFooterContent, null) : /*#__PURE__*/_react.default.createElement(_2.PasteJsonTextFooterContent, null)));
};
exports.JsonFlyout = JsonFlyout;