"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageQueriesModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _multi_input_rows = require("../../../multi_input_rows");
var _constants2 = require("../../constants");
var _curation_logic = require("../curation_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageQueriesModal = () => {
  const {
    queries,
    queriesLoading
  } = (0, _kea.useValues)(_curation_logic.CurationLogic);
  const {
    updateQueries
  } = (0, _kea.useActions)(_curation_logic.CurationLogic);
  const [isModalVisible, setModalVisibility] = (0, _react.useState)(false);
  const showModal = () => setModalVisibility(true);
  const hideModal = () => setModalVisibility(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: showModal,
    isLoading: queriesLoading
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.manageQueryButtonLabel', {
    defaultMessage: 'Manage queries'
  })), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: hideModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.manageQueryTitle', {
    defaultMessage: 'Manage queries'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.manageQueryDescription', {
    defaultMessage: 'Edit, add, or remove queries for this curation.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_multi_input_rows.MultiInputRows, {
    id: "manageCurationQueries",
    initialValues: queries,
    addRowText: _constants2.QUERY_INPUTS_BUTTON,
    inputPlaceholder: _constants2.QUERY_INPUTS_PLACEHOLDER,
    submitButtonText: _constants.SAVE_BUTTON_LABEL,
    onSubmit: newQueries => {
      updateQueries(newQueries);
      hideModal();
    }
  }))));
};
exports.ManageQueriesModal = ManageQueriesModal;