"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Curation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _layout = require("../../../../shared/layout");
var _automated_curation = require("./automated_curation");
var _curation_logic = require("./curation_logic");
var _manual_curation = require("./manual_curation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Curation = () => {
  const {
    curationId
  } = (0, _reactRouterDom.useParams)();
  const {
    loadCuration
  } = (0, _kea.useActions)((0, _curation_logic.CurationLogic)({
    curationId
  }));
  const {
    dataLoading,
    isAutomated
  } = (0, _kea.useValues)((0, _curation_logic.CurationLogic)({
    curationId
  }));
  (0, _react.useEffect)(() => {
    loadCuration();
  }, [curationId]);
  if (dataLoading) {
    return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, {
      isLoading: true
    });
  }
  return isAutomated ? /*#__PURE__*/_react.default.createElement(_automated_curation.AutomatedCuration, null) : /*#__PURE__*/_react.default.createElement(_manual_curation.ManualCuration, null);
};
exports.Curation = Curation;