"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Credentials = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _external_url = require("../../../shared/enterprise_search_url/external_url");
var _layout = require("../layout");
var _constants = require("./constants");
var _credentials_flyout = require("./credentials_flyout");
var _credentials_list = require("./credentials_list");
var _credentials_logic = require("./credentials_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Credentials = () => {
  const {
    fetchCredentials,
    fetchDetails,
    resetCredentials,
    showCredentialsForm
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  const {
    meta,
    dataLoading,
    shouldShowCredentialsForm
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  (0, _react.useEffect)(() => {
    fetchCredentials();
  }, [meta.page.current]);
  (0, _react.useEffect)(() => {
    fetchDetails();
    return () => {
      resetCredentials();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: [_constants.CREDENTIALS_TITLE],
    pageHeader: {
      pageTitle: _constants.CREDENTIALS_TITLE
    }
  }, shouldShowCredentialsForm && /*#__PURE__*/_react.default.createElement(_credentials_flyout.CredentialsFlyout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    className: "eui-textCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.apiEndpoint', {
    defaultMessage: 'Endpoint'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: _external_url.externalUrl.enterpriseSearchUrl,
    afterMessage: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.copied', {
      defaultMessage: 'Copied'
    })
  }, copy => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.copyApiEndpoint', {
      defaultMessage: 'Copy API Endpoint to clipboard.'
    })
  }), _external_url.externalUrl.enterpriseSearchUrl))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.apiKeys', {
    defaultMessage: 'API keys'
  }))), !dataLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "CreateAPIKeyButton",
    fill: true,
    onClick: () => showCredentialsForm()
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.createKey', {
    defaultMessage: 'Create key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    isLoading: !!dataLoading
  }, /*#__PURE__*/_react.default.createElement(_credentials_list.CredentialsList, null))));
};
exports.Credentials = Credentials;