"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readableCrawlerStatuses = exports.readableCrawlTypes = exports.getReadableCrawlerRule = exports.getReadableCrawlerPolicy = exports.CrawlerStatus = exports.CrawlerRules = exports.CrawlerPolicies = exports.CrawlUnits = exports.CrawlType = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let CrawlerPolicies;
exports.CrawlerPolicies = CrawlerPolicies;
(function (CrawlerPolicies) {
  CrawlerPolicies["allow"] = "allow";
  CrawlerPolicies["deny"] = "deny";
})(CrawlerPolicies || (exports.CrawlerPolicies = CrawlerPolicies = {}));
const getReadableCrawlerPolicy = policy => {
  switch (policy) {
    case CrawlerPolicies.allow:
      return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesPolicies.allowLabel', {
        defaultMessage: 'Allow'
      });
    case CrawlerPolicies.deny:
      return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesPolicies.disallowLabel', {
        defaultMessage: 'Disallow'
      });
  }
};
exports.getReadableCrawlerPolicy = getReadableCrawlerPolicy;
let CrawlerRules;
exports.CrawlerRules = CrawlerRules;
(function (CrawlerRules) {
  CrawlerRules["beginsWith"] = "begins";
  CrawlerRules["endsWith"] = "ends";
  CrawlerRules["contains"] = "contains";
  CrawlerRules["regex"] = "regex";
})(CrawlerRules || (exports.CrawlerRules = CrawlerRules = {}));
const getReadableCrawlerRule = rule => {
  switch (rule) {
    case CrawlerRules.beginsWith:
      return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesCrawlerRules.beginsWithLabel', {
        defaultMessage: 'Begins with'
      });
    case CrawlerRules.endsWith:
      return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesCrawlerRules.endsWithLabel', {
        defaultMessage: 'Ends with'
      });
    case CrawlerRules.contains:
      return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesCrawlerRules.containsLabel', {
        defaultMessage: 'Contains'
      });
    case CrawlerRules.regex:
      return _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlRulesCrawlerRules.regexLabel', {
        defaultMessage: 'Regex'
      });
  }
};
exports.getReadableCrawlerRule = getReadableCrawlerRule;
// See SharedTogo::Crawler::Status for details on how these are generated
let CrawlerStatus;
exports.CrawlerStatus = CrawlerStatus;
(function (CrawlerStatus) {
  CrawlerStatus["Pending"] = "pending";
  CrawlerStatus["Suspended"] = "suspended";
  CrawlerStatus["Starting"] = "starting";
  CrawlerStatus["Running"] = "running";
  CrawlerStatus["Suspending"] = "suspending";
  CrawlerStatus["Canceling"] = "canceling";
  CrawlerStatus["Success"] = "success";
  CrawlerStatus["Failed"] = "failed";
  CrawlerStatus["Canceled"] = "canceled";
  CrawlerStatus["Skipped"] = "skipped";
})(CrawlerStatus || (exports.CrawlerStatus = CrawlerStatus = {}));
let CrawlType;
exports.CrawlType = CrawlType;
(function (CrawlType) {
  CrawlType["Full"] = "full";
  CrawlType["Partial"] = "partial";
})(CrawlType || (exports.CrawlType = CrawlType = {}));
const readableCrawlerStatuses = {
  [CrawlerStatus.Pending]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.pending', {
    defaultMessage: 'Pending'
  }),
  [CrawlerStatus.Suspended]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.suspended', {
    defaultMessage: 'Suspended'
  }),
  [CrawlerStatus.Starting]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.starting', {
    defaultMessage: 'Starting'
  }),
  [CrawlerStatus.Running]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.running', {
    defaultMessage: 'Running'
  }),
  [CrawlerStatus.Suspending]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.suspending', {
    defaultMessage: 'Suspending'
  }),
  [CrawlerStatus.Canceling]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.canceling', {
    defaultMessage: 'Canceling'
  }),
  [CrawlerStatus.Success]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.success', {
    defaultMessage: 'Success'
  }),
  [CrawlerStatus.Failed]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.failed', {
    defaultMessage: 'Failed'
  }),
  [CrawlerStatus.Canceled]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.canceled', {
    defaultMessage: 'Canceled'
  }),
  [CrawlerStatus.Skipped]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlerStatusOptions.skipped', {
    defaultMessage: 'Skipped'
  })
};
exports.readableCrawlerStatuses = readableCrawlerStatuses;
const readableCrawlTypes = {
  [CrawlType.Full]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlTypeOptions.full', {
    defaultMessage: 'Full'
  }),
  [CrawlType.Partial]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlTypeOptions.partial', {
    defaultMessage: 'Partial'
  })
};
exports.readableCrawlTypes = readableCrawlTypes;
// The BE uses a singular form of each unit
// See shared_togo/app/models/shared_togo/crawler/crawl_schedule.rb
let CrawlUnits;
exports.CrawlUnits = CrawlUnits;
(function (CrawlUnits) {
  CrawlUnits["hours"] = "hour";
  CrawlUnits["days"] = "day";
  CrawlUnits["weeks"] = "week";
  CrawlUnits["months"] = "month";
})(CrawlUnits || (exports.CrawlUnits = CrawlUnits = {}));