"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlDetailsPreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _accordion_list = require("../../../../../shared/accordion_list/accordion_list");
var _crawl_detail_logic = require("../../crawl_detail_logic");
var _crawl_details_summary = require("./crawl_details_summary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlDetailsPreview = ({
  crawlerLogsEnabled = false
}) => {
  const {
    crawlRequest
  } = (0, _kea.useValues)(_crawl_detail_logic.CrawlDetailLogic);
  if (crawlRequest === null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_crawl_details_summary.CrawlDetailsSummary, {
    crawlerLogsEnabled: crawlerLogsEnabled,
    crawlType: crawlRequest.type,
    domainCount: crawlRequest.crawlConfig.domainAllowlist.length,
    crawlDepth: crawlRequest.crawlConfig.maxCrawlDepth,
    stats: crawlRequest.stats || null
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_accordion_list.AccordionList, {
    hasBorder: true,
    initialIsOpen: crawlRequest.crawlConfig.domainAllowlist.length > 0,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsPreview.domainsTitle', {
      defaultMessage: 'Domains'
    }),
    iconType: "globe",
    items: crawlRequest.crawlConfig.domainAllowlist
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_accordion_list.AccordionList, {
    hasBorder: true,
    initialIsOpen: crawlRequest.crawlConfig.seedUrls.length > 0,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsPreview.seedUrlsTitle', {
      defaultMessage: 'Seed URLs'
    }),
    iconType: "crosshairs",
    items: crawlRequest.crawlConfig.seedUrls
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_accordion_list.AccordionList, {
    hasBorder: true,
    initialIsOpen: crawlRequest.crawlConfig.sitemapUrls.length > 0,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlDetailsPreview.sitemapUrlsTitle', {
      defaultMessage: 'Sitemap URLs'
    }),
    iconType: "visMapRegion",
    items: crawlRequest.crawlConfig.sitemapUrls
  }));
};
exports.CrawlDetailsPreview = CrawlDetailsPreview;