"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.X_AXIS_DATE_FORMAT = exports.TOTAL_QUERIES_NO_RESULTS = exports.TOTAL_QUERIES = exports.TOTAL_DOCUMENTS = exports.TOTAL_CLICKS = exports.TOTAL_API_OPERATIONS = exports.TOP_QUERIES_WITH_CLICKS = exports.TOP_QUERIES_NO_RESULTS = exports.TOP_QUERIES_NO_CLICKS = exports.TOP_QUERIES = exports.TOOLTIP_DATE_FORMAT = exports.SERVER_DATE_FORMAT = exports.RECENT_QUERIES = exports.DEFAULT_START_DATE = exports.DEFAULT_END_DATE = exports.ANALYTICS_TITLE = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANALYTICS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.title', {
  defaultMessage: 'Analytics'
});

// Total card titles
exports.ANALYTICS_TITLE = ANALYTICS_TITLE;
const TOTAL_DOCUMENTS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalDocuments', {
  defaultMessage: 'Total documents'
});
exports.TOTAL_DOCUMENTS = TOTAL_DOCUMENTS;
const TOTAL_API_OPERATIONS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalApiOperations', {
  defaultMessage: 'Total API operations'
});
exports.TOTAL_API_OPERATIONS = TOTAL_API_OPERATIONS;
const TOTAL_QUERIES = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalQueries', {
  defaultMessage: 'Total queries'
});
exports.TOTAL_QUERIES = TOTAL_QUERIES;
const TOTAL_QUERIES_NO_RESULTS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalQueriesNoResults', {
  defaultMessage: 'Total queries with no results'
});
exports.TOTAL_QUERIES_NO_RESULTS = TOTAL_QUERIES_NO_RESULTS;
const TOTAL_CLICKS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.totalClicks', {
  defaultMessage: 'Total clicks'
});

// Queries sub-pages
exports.TOTAL_CLICKS = TOTAL_CLICKS;
const TOP_QUERIES = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.topQueriesTitle', {
  defaultMessage: 'Top queries'
});
exports.TOP_QUERIES = TOP_QUERIES;
const TOP_QUERIES_NO_RESULTS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.topQueriesNoResultsTitle', {
  defaultMessage: 'Top queries with no results'
});
exports.TOP_QUERIES_NO_RESULTS = TOP_QUERIES_NO_RESULTS;
const TOP_QUERIES_NO_CLICKS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.topQueriesNoClicksTitle', {
  defaultMessage: 'Top queries with no clicks'
});
exports.TOP_QUERIES_NO_CLICKS = TOP_QUERIES_NO_CLICKS;
const TOP_QUERIES_WITH_CLICKS = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.topQueriesWithClicksTitle', {
  defaultMessage: 'Top queries with clicks'
});
exports.TOP_QUERIES_WITH_CLICKS = TOP_QUERIES_WITH_CLICKS;
const RECENT_QUERIES = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.recentQueriesTitle', {
  defaultMessage: 'Recent queries'
});

// Date formats & dates
exports.RECENT_QUERIES = RECENT_QUERIES;
const SERVER_DATE_FORMAT = 'YYYY-MM-DD';
exports.SERVER_DATE_FORMAT = SERVER_DATE_FORMAT;
const TOOLTIP_DATE_FORMAT = 'MMMM D, YYYY';
exports.TOOLTIP_DATE_FORMAT = TOOLTIP_DATE_FORMAT;
const X_AXIS_DATE_FORMAT = 'M/D';
exports.X_AXIS_DATE_FORMAT = X_AXIS_DATE_FORMAT;
const DEFAULT_START_DATE = (0, _moment.default)().subtract(6, 'days').format(SERVER_DATE_FORMAT);
exports.DEFAULT_START_DATE = DEFAULT_START_DATE;
const DEFAULT_END_DATE = (0, _moment.default)().format(SERVER_DATE_FORMAT);
exports.DEFAULT_END_DATE = DEFAULT_END_DATE;