"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared_columns = require("./shared_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsTable = ({
  items,
  hasClicks,
  isSmall
}) => {
  const TERM_COLUMN = {
    field: 'key',
    ..._shared_columns.TERM_COLUMN_PROPS
  };
  const TAGS_COLUMN = isSmall ? _shared_columns.TAGS_COUNT_COLUMN : _shared_columns.TAGS_LIST_COLUMN;
  const COUNT_COLUMNS = [{
    field: 'searches.doc_count',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.queriesColumn', {
      defaultMessage: 'Queries'
    }),
    ..._shared_columns.COUNT_COLUMN_PROPS
  }];
  if (hasClicks) {
    COUNT_COLUMNS.push({
      field: 'clicks.doc_count',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.clicksColumn', {
        defaultMessage: 'Clicks'
      }),
      ..._shared_columns.COUNT_COLUMN_PROPS
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: [TERM_COLUMN, TAGS_COLUMN, ...COUNT_COLUMNS, _shared_columns.ACTIONS_COLUMN],
    items: items,
    responsive: true,
    hasActions: true,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visLine",
      title: /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.empty.noQueriesTitle', {
        defaultMessage: 'No queries to display'
      })),
      body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.table.empty.noQueriesDescription', {
        defaultMessage: 'No queries were performed during this time period.'
      })
    })
  });
};
exports.AnalyticsTable = AnalyticsTable;