"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../shared/kibana");
var _licensing = require("../../../shared/licensing");
var _licensing_callout = require("../../../shared/licensing_callout/licensing_callout");
var _add_analytics_collection = require("../add_analytics_collections/add_analytics_collection");
var _page_template = require("../layout/page_template");
var _analytics_collection_table = require("./analytics_collection_table");
var _analytics_collections_logic = require("./analytics_collections_logic");
var _analytics_overview_empty_page = require("./analytics_overview_empty_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsOverview = () => {
  const {
    fetchAnalyticsCollections,
    searchAnalyticsCollections
  } = (0, _kea.useActions)(_analytics_collections_logic.AnalyticsCollectionsLogic);
  const {
    analyticsCollections,
    hasNoAnalyticsCollections,
    isFetching,
    isSearching
  } = (0, _kea.useValues)(_analytics_collections_logic.AnalyticsCollectionsLogic);
  const {
    isCloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const isGated = !isCloud && !hasPlatinumLicense;
  (0, _react.useEffect)(() => {
    if (isGated) return;
    fetchAnalyticsCollections();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchAnalyticsPageTemplate, {
    pageChrome: [],
    restrictWidth: true,
    isLoading: isFetching && !isGated,
    pageViewTelemetry: "Analytics Collections Overview",
    pageHeader: {
      description: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.pageDescription', {
        defaultMessage: 'Dashboards and tools for visualizing end-user behavior and measuring the performance of your search applications. Track trends over time, identify and investigate anomalies, and make optimizations.'
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.pageTitle', {
        defaultMessage: 'Behavioral Analytics'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_add_analytics_collection.AddAnalyticsCollection, {
        disabled: isGated
      })]
    }
  }, isGated ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_licensing_callout.LicensingCallout, {
    feature: _licensing_callout.LICENSING_FEATURE.ANALYTICS
  })) : hasNoAnalyticsCollections && !isSearching ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_analytics_overview_empty_page.AnalyticsOverviewEmptyPage, null)) : /*#__PURE__*/_react.default.createElement(_analytics_collection_table.AnalyticsCollectionTable, {
    collections: analyticsCollections,
    isSearching: isSearching,
    onSearch: searchAnalyticsCollections
  }));
};
exports.AnalyticsOverview = AnalyticsOverview;