"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.valueClickTrigger = exports.selectRangeTrigger = exports.panelNotificationTrigger = exports.panelHoverTrigger = exports.panelBadgeTrigger = exports.multiValueClickTrigger = exports.isValueClickTriggerContext = exports.isRowClickTriggerContext = exports.isRangeSelectTriggerContext = exports.isMultiValueClickTriggerContext = exports.isContextMenuTriggerContext = exports.contextMenuTrigger = exports.cellValueTrigger = exports.VALUE_CLICK_TRIGGER = exports.SELECT_RANGE_TRIGGER = exports.PANEL_NOTIFICATION_TRIGGER = exports.PANEL_HOVER_TRIGGER = exports.PANEL_BADGE_TRIGGER = exports.MULTI_VALUE_CLICK_TRIGGER = exports.CONTEXT_MENU_TRIGGER = exports.CELL_VALUE_TRIGGER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CONTEXT_MENU_TRIGGER = 'CONTEXT_MENU_TRIGGER';
exports.CONTEXT_MENU_TRIGGER = CONTEXT_MENU_TRIGGER;
const contextMenuTrigger = {
  id: CONTEXT_MENU_TRIGGER,
  title: _i18n.i18n.translate('embeddableApi.contextMenuTrigger.title', {
    defaultMessage: 'Context menu'
  }),
  description: _i18n.i18n.translate('embeddableApi.contextMenuTrigger.description', {
    defaultMessage: "A new action will be added to the panel's context menu"
  })
};
exports.contextMenuTrigger = contextMenuTrigger;
const PANEL_HOVER_TRIGGER = 'PANEL_HOVER_TRIGGER';
exports.PANEL_HOVER_TRIGGER = PANEL_HOVER_TRIGGER;
const panelHoverTrigger = {
  id: PANEL_HOVER_TRIGGER,
  title: _i18n.i18n.translate('embeddableApi.panelHoverTrigger.title', {
    defaultMessage: 'Panel hover'
  }),
  description: _i18n.i18n.translate('embeddableApi.panelHoverTrigger.description', {
    defaultMessage: "A new action will be added to the panel's hover menu"
  })
};
exports.panelHoverTrigger = panelHoverTrigger;
const PANEL_BADGE_TRIGGER = 'PANEL_BADGE_TRIGGER';
exports.PANEL_BADGE_TRIGGER = PANEL_BADGE_TRIGGER;
const panelBadgeTrigger = {
  id: PANEL_BADGE_TRIGGER,
  title: _i18n.i18n.translate('embeddableApi.panelBadgeTrigger.title', {
    defaultMessage: 'Panel badges'
  }),
  description: _i18n.i18n.translate('embeddableApi.panelBadgeTrigger.description', {
    defaultMessage: 'Actions appear in title bar when an embeddable loads in a panel.'
  })
};
exports.panelBadgeTrigger = panelBadgeTrigger;
const PANEL_NOTIFICATION_TRIGGER = 'PANEL_NOTIFICATION_TRIGGER';
exports.PANEL_NOTIFICATION_TRIGGER = PANEL_NOTIFICATION_TRIGGER;
const panelNotificationTrigger = {
  id: PANEL_NOTIFICATION_TRIGGER,
  title: _i18n.i18n.translate('embeddableApi.panelNotificationTrigger.title', {
    defaultMessage: 'Panel notifications'
  }),
  description: _i18n.i18n.translate('embeddableApi.panelNotificationTrigger.description', {
    defaultMessage: 'Actions appear in top-right corner of a panel.'
  })
};
exports.panelNotificationTrigger = panelNotificationTrigger;
const SELECT_RANGE_TRIGGER = 'SELECT_RANGE_TRIGGER';
exports.SELECT_RANGE_TRIGGER = SELECT_RANGE_TRIGGER;
const selectRangeTrigger = {
  id: SELECT_RANGE_TRIGGER,
  title: _i18n.i18n.translate('embeddableApi.selectRangeTrigger.title', {
    defaultMessage: 'Range selection'
  }),
  description: _i18n.i18n.translate('embeddableApi.selectRangeTrigger.description', {
    defaultMessage: 'A range of values on the visualization'
  })
};
exports.selectRangeTrigger = selectRangeTrigger;
const VALUE_CLICK_TRIGGER = 'VALUE_CLICK_TRIGGER';
exports.VALUE_CLICK_TRIGGER = VALUE_CLICK_TRIGGER;
const valueClickTrigger = {
  id: VALUE_CLICK_TRIGGER,
  title: _i18n.i18n.translate('embeddableApi.valueClickTrigger.title', {
    defaultMessage: 'Single click'
  }),
  description: _i18n.i18n.translate('embeddableApi.valueClickTrigger.description', {
    defaultMessage: 'A data point click on the visualization'
  })
};
exports.valueClickTrigger = valueClickTrigger;
const MULTI_VALUE_CLICK_TRIGGER = 'MULTI_VALUE_CLICK_TRIGGER';
exports.MULTI_VALUE_CLICK_TRIGGER = MULTI_VALUE_CLICK_TRIGGER;
const multiValueClickTrigger = {
  id: MULTI_VALUE_CLICK_TRIGGER,
  title: _i18n.i18n.translate('embeddableApi.multiValueClickTrigger.title', {
    defaultMessage: 'Multi click'
  }),
  description: _i18n.i18n.translate('embeddableApi.multiValueClickTrigger.description', {
    defaultMessage: 'Selecting multiple values of a single dimension on the visualization'
  })
};
exports.multiValueClickTrigger = multiValueClickTrigger;
const CELL_VALUE_TRIGGER = 'CELL_VALUE_TRIGGER';
exports.CELL_VALUE_TRIGGER = CELL_VALUE_TRIGGER;
const cellValueTrigger = {
  id: CELL_VALUE_TRIGGER,
  title: _i18n.i18n.translate('embeddableApi.cellValueTrigger.title', {
    defaultMessage: 'Cell value'
  }),
  description: _i18n.i18n.translate('embeddableApi.cellValueTrigger.description', {
    defaultMessage: 'Actions appear in the cell value options on the visualization'
  })
};
exports.cellValueTrigger = cellValueTrigger;
const isValueClickTriggerContext = context => {
  return context.data && 'data' in context.data && Array.isArray(context.data.data) && context.data.data.length > 0 && 'column' in context.data.data[0];
};
exports.isValueClickTriggerContext = isValueClickTriggerContext;
const isMultiValueClickTriggerContext = context => {
  return context.data && 'data' in context.data && Array.isArray(context.data.data) && context.data.data.length > 0 && 'cells' in context.data.data[0];
};
exports.isMultiValueClickTriggerContext = isMultiValueClickTriggerContext;
const isRangeSelectTriggerContext = context => context.data && 'range' in context.data;
exports.isRangeSelectTriggerContext = isRangeSelectTriggerContext;
const isRowClickTriggerContext = context => !!context.data && typeof context.data === 'object' && typeof context.data.rowIndex === 'number';
exports.isRowClickTriggerContext = isRowClickTriggerContext;
const isContextMenuTriggerContext = context => !!context && typeof context === 'object' && !!context.embeddable && typeof context.embeddable === 'object';
exports.isContextMenuTriggerContext = isContextMenuTriggerContext;