"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContactCardExportableEmbeddable = exports.CONTACT_EXPORTABLE_USER_TRIGGER = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _contact_card_embeddable = require("./contact_card_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ContactCardExportableEmbeddable extends _contact_card_embeddable.ContactCardEmbeddable {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getInspectorAdapters", () => {
      return {
        tables: {
          allowCsvExport: true,
          tables: {
            layer1: {
              type: 'datatable',
              columns: [{
                id: 'firstName',
                name: 'First Name'
              }, {
                id: 'originalLastName',
                name: 'Last Name'
              }],
              rows: [{
                firstName: this.getInput().firstName,
                orignialLastName: this.getInput().lastName
              }]
            }
          }
        }
      };
    });
  }
}
exports.ContactCardExportableEmbeddable = ContactCardExportableEmbeddable;
const CONTACT_EXPORTABLE_USER_TRIGGER = 'CONTACT_EXPORTABLE_USER_TRIGGER';
exports.CONTACT_EXPORTABLE_USER_TRIGGER = CONTACT_EXPORTABLE_USER_TRIGGER;