"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SayHelloAction = exports.SAY_HELLO_ACTION = void 0;
exports.hasFullNameOutput = hasFullNameOutput;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ui_actions = require("../../ui_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SAY_HELLO_ACTION = 'SAY_HELLO_ACTION';
exports.SAY_HELLO_ACTION = SAY_HELLO_ACTION;
function hasFullNameOutput(embeddable) {
  return embeddable.getOutput().fullName !== undefined;
}
class SayHelloAction {
  // Taking in a function, instead of always directly interacting with the dom,
  // can make testing the execute part of the action easier.
  constructor(sayHello) {
    (0, _defineProperty2.default)(this, "type", SAY_HELLO_ACTION);
    (0, _defineProperty2.default)(this, "id", SAY_HELLO_ACTION);
    (0, _defineProperty2.default)(this, "sayHello", void 0);
    this.sayHello = sayHello;
  }
  getDisplayName() {
    return 'Say hello';
  }
  getIconType() {
    return undefined;
  }

  // Can use typescript generics to get compiler time warnings for immediate feedback if
  // the context is not compatible.
  async isCompatible(context) {
    // Option 1: only compatible with Greeting Embeddables.
    // return context.embeddable.type === CONTACT_CARD_EMBEDDABLE;

    // Option 2: require an embeddable with a specific input or output shape
    return hasFullNameOutput(context.embeddable);
  }
  async execute(context) {
    if (!(await this.isCompatible(context))) {
      throw new _ui_actions.IncompatibleActionError();
    }
    const greeting = `Hello, ${context.embeddable.getOutput().fullName}`;
    if (context.message) {
      this.sayHello(`${greeting}.  ${context.message}`);
    } else {
      this.sayHello(greeting);
    }
  }
}
exports.SayHelloAction = SayHelloAction;