"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelNotFoundError = exports.EmbeddableFactoryNotFoundError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable max-classes-per-file */

class PanelNotFoundError extends Error {
  constructor() {
    super(_i18n.i18n.translate('embeddableApi.errors.paneldoesNotExist', {
      defaultMessage: 'Panel not found'
    }));
    (0, _defineProperty2.default)(this, "code", 'PANEL_NOT_FOUND');
  }
}
exports.PanelNotFoundError = PanelNotFoundError;
class EmbeddableFactoryNotFoundError extends Error {
  constructor(type) {
    super(_i18n.i18n.translate('embeddableApi.errors.embeddableFactoryNotFound', {
      defaultMessage: `{type} can't be loaded. Please upgrade to the default distribution of Elasticsearch and Kibana with the appropriate license.`,
      values: {
        type
      }
    }));
    (0, _defineProperty2.default)(this, "code", 'EMBEDDABLE_FACTORY_NOT_FOUND');
  }
}
exports.EmbeddableFactoryNotFoundError = EmbeddableFactoryNotFoundError;