"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectPanelAction = exports.ACTION_INSPECT_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _track_overlays = require("../track_overlays");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_INSPECT_PANEL = 'openInspector';
exports.ACTION_INSPECT_PANEL = ACTION_INSPECT_PANEL;
class InspectPanelAction {
  constructor(inspector) {
    (0, _defineProperty2.default)(this, "type", ACTION_INSPECT_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_INSPECT_PANEL);
    (0, _defineProperty2.default)(this, "order", 20);
    this.inspector = inspector;
  }
  getDisplayName() {
    return _i18n.i18n.translate('embeddableApi.panel.inspectPanel.displayName', {
      defaultMessage: 'Inspect'
    });
  }
  getIconType() {
    return 'inspect';
  }
  async isCompatible({
    embeddable
  }) {
    return this.inspector.isAvailable(embeddable.getInspectorAdapters());
  }
  async execute({
    embeddable
  }) {
    const adapters = embeddable.getInspectorAdapters();
    if (!(await this.isCompatible({
      embeddable
    })) || adapters === undefined) {
      throw new Error('Action not compatible with context');
    }

    // send the overlay ref to the root embeddable if it is capable of tracking overlays
    const rootEmbeddable = embeddable.getRoot();
    const overlayTracker = (0, _track_overlays.tracksOverlays)(rootEmbeddable) ? rootEmbeddable : undefined;
    const session = this.inspector.open(adapters, {
      title: embeddable.getTitle(),
      options: {
        fileName: embeddable.getTitle() ||
        // pick the visible title
        embeddable.getInput().title ||
        // or the custom title if used, but currently hidden
        embeddable.getOutput().defaultTitle ||
        // or the saved title
        // in the very last resort use "untitled"
        _i18n.i18n.translate('embeddableApi.panel.inspectPanel.untitledEmbeddableFilename', {
          defaultMessage: 'untitled'
        })
      }
    });
    // Overwrite the embeddables.destroy() function to close the inspector
    // before calling the original destroy method
    const originalDestroy = embeddable.destroy;
    embeddable.destroy = () => {
      if (overlayTracker) overlayTracker.clearOverlays();
      session.close();
      if (originalDestroy) {
        originalDestroy.call(embeddable);
      }
    };

    // In case the inspector gets closed (otherwise), restore the original destroy function
    session.onClose.finally(() => {
      if (overlayTracker) overlayTracker.clearOverlays();
      embeddable.destroy = originalDestroy;
    });
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(session);
  }
}
exports.InspectPanelAction = InspectPanelAction;