"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postActionsConnectorExecuteRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _executor = require("../lib/executor");
var _constants = require("../../common/constants");
var _helpers = require("../lib/langchain/helpers");
var _build_response = require("../lib/build_response");
var _common = require("../schemas/common");
var _post_actions_connector_execute = require("../schemas/post_actions_connector_execute");
var _constants2 = require("./knowledge_base/constants");
var _execute_custom_llm_chain = require("../lib/langchain/execute_custom_llm_chain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postActionsConnectorExecuteRoute = (router, getElser) => {
  router.post({
    path: _constants.POST_ACTIONS_CONNECTOR_EXECUTE,
    validate: {
      body: (0, _common.buildRouteValidation)(_post_actions_connector_execute.PostActionsConnectorExecuteBody),
      params: (0, _common.buildRouteValidation)(_post_actions_connector_execute.PostActionsConnectorExecutePathParams)
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    const logger = (await context.elasticAssistant).logger;
    try {
      const connectorId = decodeURIComponent(request.params.connectorId);

      // get the actions plugin start contract from the request context:
      const actions = (await context.elasticAssistant).actions;

      // if not langchain, call execute action directly and return the response:
      if (!request.body.assistantLangChain && !(0, _helpers.requestHasRequiredAnonymizationParams)(request)) {
        logger.debug('Executing via actions framework directly');
        const result = await (0, _executor.executeAction)({
          actions,
          request,
          connectorId
        });
        return response.ok({
          body: result
        });
      }

      // TODO: Add `traceId` to actions request when calling via langchain
      logger.debug('Executing via langchain, assistantLangChain: true');

      // get a scoped esClient for assistant memory
      const esClient = (await context.core).elasticsearch.client.asCurrentUser;

      // convert the assistant messages to LangChain messages:
      const langChainMessages = (0, _helpers.getLangChainMessages)(request.body.params.subActionParams.messages);
      const elserId = await getElser(request, (await context.core).savedObjects.getClient());
      let latestReplacements = {
        ...request.body.replacements
      };
      const onNewReplacements = newReplacements => {
        latestReplacements = {
          ...latestReplacements,
          ...newReplacements
        };
      };
      const langChainResponseBody = await (0, _execute_custom_llm_chain.callAgentExecutor)({
        alertsIndexPattern: request.body.alertsIndexPattern,
        allow: request.body.allow,
        allowReplacement: request.body.allowReplacement,
        actions,
        assistantLangChain: request.body.assistantLangChain,
        connectorId,
        elserId,
        esClient,
        kbResource: _constants2.ESQL_RESOURCE,
        langChainMessages,
        logger,
        onNewReplacements,
        request,
        replacements: request.body.replacements,
        size: request.body.size
      });
      return response.ok({
        body: {
          ...langChainResponseBody,
          replacements: latestReplacements
        }
      });
    } catch (err) {
      logger.error(err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.postActionsConnectorExecuteRoute = postActionsConnectorExecuteRoute;