"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOpenAndAcknowledgedAlertsTool = exports.OPEN_ALERTS_TOOL_DESCRIPTION = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _tools = require("langchain/tools");
var _helpers = require("../../helpers");
var _get_open_and_acknowledged_alerts_query = require("./get_open_and_acknowledged_alerts_query");
var _helpers2 = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_ALERTS_TOOL_DESCRIPTION = 'Call this for knowledge about the latest n open alerts (sorted by `kibana.alert.risk_score`) in the environment, or when answering questions about open alerts';

/**
 * Returns a tool for querying open and acknowledged alerts, or null if the
 * request doesn't have all the required parameters.
 */
exports.OPEN_ALERTS_TOOL_DESCRIPTION = OPEN_ALERTS_TOOL_DESCRIPTION;
const getOpenAndAcknowledgedAlertsTool = ({
  alertsIndexPattern,
  allow,
  allowReplacement,
  esClient,
  onNewReplacements,
  replacements,
  request,
  size
}) => {
  if (!(0, _helpers.requestHasRequiredAnonymizationParams)(request) || alertsIndexPattern == null || size == null || (0, _helpers2.sizeIsOutOfRange)(size)) {
    return null;
  }
  return new _tools.DynamicTool({
    name: 'open-alerts',
    description: OPEN_ALERTS_TOOL_DESCRIPTION,
    func: async () => {
      var _result$hits, _result$hits$hits;
      const query = (0, _get_open_and_acknowledged_alerts_query.getOpenAndAcknowledgedAlertsQuery)({
        alertsIndexPattern,
        allow: allow !== null && allow !== void 0 ? allow : [],
        size
      });
      const result = await esClient.search(query);

      // Accumulate replacements locally so we can, for example use the same
      // replacement for a hostname when we see it in multiple alerts:
      let localReplacements = {
        ...replacements
      };
      const localOnNewReplacements = newReplacements => {
        localReplacements = {
          ...localReplacements,
          ...newReplacements
        }; // update the local state

        onNewReplacements === null || onNewReplacements === void 0 ? void 0 : onNewReplacements(localReplacements); // invoke the callback with the latest replacements
      };

      return JSON.stringify((_result$hits = result.hits) === null || _result$hits === void 0 ? void 0 : (_result$hits$hits = _result$hits.hits) === null || _result$hits$hits === void 0 ? void 0 : _result$hits$hits.map(x => (0, _elasticAssistantCommon.transformRawData)({
        allow: allow !== null && allow !== void 0 ? allow : [],
        allowReplacement: allowReplacement !== null && allowReplacement !== void 0 ? allowReplacement : [],
        currentReplacements: localReplacements,
        // <-- the latest local replacements
        getAnonymizedValue: _elasticAssistantCommon.getAnonymizedValue,
        onNewReplacements: localOnNewReplacements,
        // <-- the local callback
        rawData: (0, _helpers2.getRawDataOrDefault)(x.fields)
      })));
    },
    tags: ['alerts', 'open-alerts']
  });
};
exports.getOpenAndAcknowledgedAlertsTool = getOpenAndAcknowledgedAlertsTool;