"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsClientLlm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classPrivateFieldGet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldGet"));
var _classPrivateFieldSet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldSet"));
var _uuid = require("uuid");
var _base = require("langchain/llms/base");
var _fp = require("lodash/fp");
var _helpers = require("../helpers");
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } } /*
                                                                                                                                                                                            * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                            * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                            * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                            * 2.0.
                                                                                                                                                                                            */
const LLM_TYPE = 'ActionsClientLlm';
var _actions = /*#__PURE__*/new WeakMap();
var _connectorId = /*#__PURE__*/new WeakMap();
var _logger = /*#__PURE__*/new WeakMap();
var _request = /*#__PURE__*/new WeakMap();
var _actionResultData = /*#__PURE__*/new WeakMap();
var _traceId = /*#__PURE__*/new WeakMap();
class ActionsClientLlm extends _base.LLM {
  // Local `llmType` as it can change and needs to be accessed by abstract `_llmType()` method
  // Not using getter as `this._llmType()` is called in the constructor via `super({})`
  constructor({
    actions,
    connectorId,
    traceId = (0, _uuid.v4)(),
    llmType,
    logger,
    request
  }) {
    super({});
    _classPrivateFieldInitSpec(this, _actions, {
      writable: true,
      value: void 0
    });
    _classPrivateFieldInitSpec(this, _connectorId, {
      writable: true,
      value: void 0
    });
    _classPrivateFieldInitSpec(this, _logger, {
      writable: true,
      value: void 0
    });
    _classPrivateFieldInitSpec(this, _request, {
      writable: true,
      value: void 0
    });
    _classPrivateFieldInitSpec(this, _actionResultData, {
      writable: true,
      value: void 0
    });
    _classPrivateFieldInitSpec(this, _traceId, {
      writable: true,
      value: void 0
    });
    (0, _defineProperty2.default)(this, "llmType", void 0);
    (0, _classPrivateFieldSet2.default)(this, _actions, actions);
    (0, _classPrivateFieldSet2.default)(this, _connectorId, connectorId);
    (0, _classPrivateFieldSet2.default)(this, _traceId, traceId);
    this.llmType = llmType !== null && llmType !== void 0 ? llmType : LLM_TYPE;
    (0, _classPrivateFieldSet2.default)(this, _logger, logger);
    (0, _classPrivateFieldSet2.default)(this, _request, request);
    (0, _classPrivateFieldSet2.default)(this, _actionResultData, '');
  }
  getActionResultData() {
    return (0, _classPrivateFieldGet2.default)(this, _actionResultData);
  }
  _llmType() {
    return this.llmType;
  }

  // Model type needs to be `base_chat_model` to work with LangChain OpenAI Tools
  // We may want to make this configurable (ala _llmType) if different agents end up requiring different model types
  // See: https://github.com/langchain-ai/langchainjs/blob/fb699647a310c620140842776f4a7432c53e02fa/langchain/src/agents/openai/index.ts#L185
  _modelType() {
    return 'base_chat_model';
  }
  async _call(prompt) {
    // convert the Langchain prompt to an assistant message:
    const assistantMessage = (0, _helpers.getMessageContentAndRole)(prompt);
    (0, _classPrivateFieldGet2.default)(this, _logger).debug(`ActionsClientLlm#_call\ntraceId: ${(0, _classPrivateFieldGet2.default)(this, _traceId)}\nassistantMessage:\n${JSON.stringify(assistantMessage)} `);
    // create a new connector request body with the assistant message:
    const requestBody = {
      actionId: (0, _classPrivateFieldGet2.default)(this, _connectorId),
      params: {
        ...(0, _classPrivateFieldGet2.default)(this, _request).body.params,
        // the original request body params
        subActionParams: {
          ...(0, _classPrivateFieldGet2.default)(this, _request).body.params.subActionParams,
          // the original request body params.subActionParams
          messages: [assistantMessage] // the assistant message
        }
      }
    };

    // create an actions client from the authenticated request context:
    const actionsClient = await (0, _classPrivateFieldGet2.default)(this, _actions).getActionsClientWithRequest((0, _classPrivateFieldGet2.default)(this, _request));
    const actionResult = await actionsClient.execute(requestBody);
    if (actionResult.status === 'error') {
      throw new Error(`${LLM_TYPE}: action result status is error: ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.message} - ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage}`);
    }
    const content = (0, _fp.get)('data.message', actionResult);
    if (typeof content !== 'string') {
      throw new Error(`${LLM_TYPE}: content should be a string, but it had an unexpected type: ${typeof content}`);
    }
    (0, _classPrivateFieldSet2.default)(this, _actionResultData, content); // save the raw response from the connector, because that's what the assistant expects

    return content; // per the contact of _call, return a string
  }
}
exports.ActionsClientLlm = ActionsClientLlm;