"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EcsDataQualityDashboardPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EcsDataQualityDashboardPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core) {
    this.logger.debug('ecsDataQualityDashboard: Setup'); // this would be deleted when plugin is removed
    const router = core.http.createRouter(); // this would be deleted when plugin is removed

    // Register server side APIs
    (0, _routes.getIndexMappingsRoute)(router, this.logger);
    (0, _routes.getIndexStatsRoute)(router, this.logger);
    (0, _routes.getUnallowedFieldValuesRoute)(router, this.logger);
    (0, _routes.getILMExplainRoute)(router, this.logger);
    return {};
  }
  start(core) {
    this.logger.debug('ecsDataQualityDashboard: Started');
    return {};
  }
  stop() {}
}
exports.EcsDataQualityDashboardPlugin = EcsDataQualityDashboardPlugin;